/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction;
import software.amazon.awssdk.services.deadline.model.QueueBlockedReason;
import software.amazon.awssdk.services.deadline.model.QueueStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueSummary> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(QueueSummary.getter(QueueSummary::farmId)).setter(QueueSummary.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(QueueSummary.getter(QueueSummary::queueId)).setter(QueueSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(QueueSummary.getter(QueueSummary::displayName)).setter(QueueSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(QueueSummary.getter(QueueSummary::statusAsString)).setter(QueueSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBudgetAction").getter(QueueSummary.getter(QueueSummary::defaultBudgetActionAsString)).setter(QueueSummary.setter(Builder::defaultBudgetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build()}).build();
    private static final SdkField<String> BLOCKED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedReason").getter(QueueSummary.getter(QueueSummary::blockedReasonAsString)).setter(QueueSummary.setter(Builder::blockedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedReason").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(QueueSummary.getter(QueueSummary::createdAt)).setter(QueueSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(QueueSummary.getter(QueueSummary::createdBy)).setter(QueueSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(QueueSummary.getter(QueueSummary::updatedAt)).setter(QueueSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(QueueSummary.getter(QueueSummary::updatedBy)).setter(QueueSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, QUEUE_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, DEFAULT_BUDGET_ACTION_FIELD, BLOCKED_REASON_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("farmId", FARM_ID_FIELD);
            this.put("queueId", QUEUE_ID_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("defaultBudgetAction", DEFAULT_BUDGET_ACTION_FIELD);
            this.put("blockedReason", BLOCKED_REASON_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String farmId;
    private final String queueId;
    private final String displayName;
    private final String status;
    private final String defaultBudgetAction;
    private final String blockedReason;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;

    private QueueSummary(BuilderImpl builder) {
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.blockedReason = builder.blockedReason;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(this.defaultBudgetAction);
    }

    public final String defaultBudgetActionAsString() {
        return this.defaultBudgetAction;
    }

    public final QueueBlockedReason blockedReason() {
        return QueueBlockedReason.fromValue(this.blockedReason);
    }

    public final String blockedReasonAsString() {
        return this.blockedReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueSummary)) {
            return false;
        }
        QueueSummary other = (QueueSummary)obj;
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.defaultBudgetActionAsString(), other.defaultBudgetActionAsString()) && Objects.equals(this.blockedReasonAsString(), other.blockedReasonAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"QueueSummary").add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("DefaultBudgetAction", (Object)this.defaultBudgetActionAsString()).add("BlockedReason", (Object)this.blockedReasonAsString()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "defaultBudgetAction": {
                return Optional.ofNullable(clazz.cast(this.defaultBudgetActionAsString()));
            }
            case "blockedReason": {
                return Optional.ofNullable(clazz.cast(this.blockedReasonAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueueSummary, T> g) {
        return obj -> g.apply((QueueSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String farmId;
        private String queueId;
        private String displayName;
        private String status;
        private String defaultBudgetAction;
        private String blockedReason;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueSummary model) {
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.defaultBudgetAction(model.defaultBudgetAction);
            this.blockedReason(model.blockedReason);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultBudgetAction() {
            return this.defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final String getBlockedReason() {
            return this.blockedReason;
        }

        public final void setBlockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Override
        public final Builder blockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
            return this;
        }

        @Override
        public final Builder blockedReason(QueueBlockedReason blockedReason) {
            this.blockedReason(blockedReason == null ? null : blockedReason.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public QueueSummary build() {
            return new QueueSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueSummary> {
        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder defaultBudgetAction(String var1);

        public Builder defaultBudgetAction(DefaultQueueBudgetAction var1);

        public Builder blockedReason(String var1);

        public Builder blockedReason(QueueBlockedReason var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

