/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.DependencyCounts;
import software.amazon.awssdk.services.deadline.model.StepLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatusCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepSummary> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(StepSummary.getter(StepSummary::stepId)).setter(StepSummary.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StepSummary.getter(StepSummary::name)).setter(StepSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(StepSummary.getter(StepSummary::lifecycleStatusAsString)).setter(StepSummary.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatusMessage").getter(StepSummary.getter(StepSummary::lifecycleStatusMessage)).setter(StepSummary.setter(Builder::lifecycleStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build()}).build();
    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRunStatus").getter(StepSummary.getter(StepSummary::taskRunStatusAsString)).setter(StepSummary.setter(Builder::taskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskRunStatusCounts").getter(StepSummary.getter(StepSummary::taskRunStatusCountsAsStrings)).setter(StepSummary.setter(Builder::taskRunStatusCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(StepSummary.getter(StepSummary::targetTaskRunStatusAsString)).setter(StepSummary.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StepSummary.getter(StepSummary::createdAt)).setter(StepSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(StepSummary.getter(StepSummary::createdBy)).setter(StepSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(StepSummary.getter(StepSummary::updatedAt)).setter(StepSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(StepSummary.getter(StepSummary::updatedBy)).setter(StepSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(StepSummary.getter(StepSummary::startedAt)).setter(StepSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(StepSummary.getter(StepSummary::endedAt)).setter(StepSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DependencyCounts> DEPENDENCY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dependencyCounts").getter(StepSummary.getter(StepSummary::dependencyCounts)).setter(StepSummary.setter(Builder::dependencyCounts)).constructor(DependencyCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, NAME_FIELD, LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, TARGET_TASK_RUN_STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, DEPENDENCY_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stepId", STEP_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
            this.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
            this.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
            this.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
            this.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("dependencyCounts", DEPENDENCY_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stepId;
    private final String name;
    private final String lifecycleStatus;
    private final String lifecycleStatusMessage;
    private final String taskRunStatus;
    private final Map<String, Integer> taskRunStatusCounts;
    private final String targetTaskRunStatus;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final Instant startedAt;
    private final Instant endedAt;
    private final DependencyCounts dependencyCounts;

    private StepSummary(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.taskRunStatus = builder.taskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.dependencyCounts = builder.dependencyCounts;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String name() {
        return this.name;
    }

    public final StepLifecycleStatus lifecycleStatus() {
        return StepLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final String lifecycleStatusMessage() {
        return this.lifecycleStatusMessage;
    }

    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(this.taskRunStatus);
    }

    public final String taskRunStatusAsString() {
        return this.taskRunStatus;
    }

    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(this.taskRunStatusCounts);
    }

    public final boolean hasTaskRunStatusCounts() {
        return this.taskRunStatusCounts != null && !(this.taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return this.taskRunStatusCounts;
    }

    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final DependencyCounts dependencyCounts() {
        return this.dependencyCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSummary)) {
            return false;
        }
        StepSummary other = (StepSummary)obj;
        return Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.lifecycleStatusMessage(), other.lifecycleStatusMessage()) && Objects.equals(this.taskRunStatusAsString(), other.taskRunStatusAsString()) && this.hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts() && Objects.equals(this.taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.dependencyCounts(), other.dependencyCounts());
    }

    public final String toString() {
        return ToString.builder((String)"StepSummary").add("StepId", (Object)this.stepId()).add("Name", (Object)this.name()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("LifecycleStatusMessage", (Object)this.lifecycleStatusMessage()).add("TaskRunStatus", (Object)this.taskRunStatusAsString()).add("TaskRunStatusCounts", this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("DependencyCounts", (Object)this.dependencyCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "lifecycleStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusMessage()));
            }
            case "taskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusAsString()));
            }
            case "taskRunStatusCounts": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusCountsAsStrings()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "dependencyCounts": {
                return Optional.ofNullable(clazz.cast(this.dependencyCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StepSummary, T> g) {
        return obj -> g.apply((StepSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String name;
        private String lifecycleStatus;
        private String lifecycleStatusMessage;
        private String taskRunStatus;
        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();
        private String targetTaskRunStatus;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private Instant startedAt;
        private Instant endedAt;
        private DependencyCounts dependencyCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSummary model) {
            this.stepId(model.stepId);
            this.name(model.name);
            this.lifecycleStatus(model.lifecycleStatus);
            this.lifecycleStatusMessage(model.lifecycleStatusMessage);
            this.taskRunStatus(model.taskRunStatus);
            this.taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.dependencyCounts(model.dependencyCounts);
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return this.lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final String getTaskRunStatus() {
            return this.taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (this.taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final DependencyCounts.Builder getDependencyCounts() {
            return this.dependencyCounts != null ? this.dependencyCounts.toBuilder() : null;
        }

        public final void setDependencyCounts(DependencyCounts.BuilderImpl dependencyCounts) {
            this.dependencyCounts = dependencyCounts != null ? dependencyCounts.build() : null;
        }

        @Override
        public final Builder dependencyCounts(DependencyCounts dependencyCounts) {
            this.dependencyCounts = dependencyCounts;
            return this;
        }

        public StepSummary build() {
            return new StepSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepSummary> {
        public Builder stepId(String var1);

        public Builder name(String var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(StepLifecycleStatus var1);

        public Builder lifecycleStatusMessage(String var1);

        public Builder taskRunStatus(String var1);

        public Builder taskRunStatus(TaskRunStatus var1);

        public Builder taskRunStatusCountsWithStrings(Map<String, Integer> var1);

        public Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(StepTargetTaskRunStatus var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder dependencyCounts(DependencyCounts var1);

        default public Builder dependencyCounts(Consumer<DependencyCounts.Builder> dependencyCounts) {
            return this.dependencyCounts((DependencyCounts)((DependencyCounts.Builder)DependencyCounts.builder().applyMutation(dependencyCounts)).build());
        }
    }
}

