/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.CustomerManagedFleetConfiguration;
import software.amazon.awssdk.services.deadline.model.ServiceManagedEc2FleetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetConfiguration> {
    private static final SdkField<CustomerManagedFleetConfiguration> CUSTOMER_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerManaged").getter(FleetConfiguration.getter(FleetConfiguration::customerManaged)).setter(FleetConfiguration.setter(Builder::customerManaged)).constructor(CustomerManagedFleetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManaged").build()}).build();
    private static final SdkField<ServiceManagedEc2FleetConfiguration> SERVICE_MANAGED_EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceManagedEc2").getter(FleetConfiguration.getter(FleetConfiguration::serviceManagedEc2)).setter(FleetConfiguration.setter(Builder::serviceManagedEc2)).constructor(ServiceManagedEc2FleetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedEc2").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_MANAGED_FIELD, SERVICE_MANAGED_EC2_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("customerManaged", CUSTOMER_MANAGED_FIELD);
            this.put("serviceManagedEc2", SERVICE_MANAGED_EC2_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CustomerManagedFleetConfiguration customerManaged;
    private final ServiceManagedEc2FleetConfiguration serviceManagedEc2;
    private final Type type;

    private FleetConfiguration(BuilderImpl builder) {
        this.customerManaged = builder.customerManaged;
        this.serviceManagedEc2 = builder.serviceManagedEc2;
        this.type = builder.type;
    }

    public final CustomerManagedFleetConfiguration customerManaged() {
        return this.customerManaged;
    }

    public final ServiceManagedEc2FleetConfiguration serviceManagedEc2() {
        return this.serviceManagedEc2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceManagedEc2());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetConfiguration)) {
            return false;
        }
        FleetConfiguration other = (FleetConfiguration)obj;
        return Objects.equals(this.customerManaged(), other.customerManaged()) && Objects.equals(this.serviceManagedEc2(), other.serviceManagedEc2());
    }

    public final String toString() {
        return ToString.builder((String)"FleetConfiguration").add("CustomerManaged", (Object)this.customerManaged()).add("ServiceManagedEc2", (Object)this.serviceManagedEc2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerManaged": {
                return Optional.ofNullable(clazz.cast(this.customerManaged()));
            }
            case "serviceManagedEc2": {
                return Optional.ofNullable(clazz.cast(this.serviceManagedEc2()));
            }
        }
        return Optional.empty();
    }

    public static FleetConfiguration fromCustomerManaged(CustomerManagedFleetConfiguration customerManaged) {
        return (FleetConfiguration)FleetConfiguration.builder().customerManaged(customerManaged).build();
    }

    public static FleetConfiguration fromCustomerManaged(Consumer<CustomerManagedFleetConfiguration.Builder> customerManaged) {
        CustomerManagedFleetConfiguration.Builder builder = CustomerManagedFleetConfiguration.builder();
        customerManaged.accept(builder);
        return FleetConfiguration.fromCustomerManaged((CustomerManagedFleetConfiguration)builder.build());
    }

    public static FleetConfiguration fromServiceManagedEc2(ServiceManagedEc2FleetConfiguration serviceManagedEc2) {
        return (FleetConfiguration)FleetConfiguration.builder().serviceManagedEc2(serviceManagedEc2).build();
    }

    public static FleetConfiguration fromServiceManagedEc2(Consumer<ServiceManagedEc2FleetConfiguration.Builder> serviceManagedEc2) {
        ServiceManagedEc2FleetConfiguration.Builder builder = ServiceManagedEc2FleetConfiguration.builder();
        serviceManagedEc2.accept(builder);
        return FleetConfiguration.fromServiceManagedEc2((ServiceManagedEc2FleetConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FleetConfiguration, T> g) {
        return obj -> g.apply((FleetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CUSTOMER_MANAGED,
        SERVICE_MANAGED_EC2,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CustomerManagedFleetConfiguration customerManaged;
        private ServiceManagedEc2FleetConfiguration serviceManagedEc2;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FleetConfiguration model) {
            this.customerManaged(model.customerManaged);
            this.serviceManagedEc2(model.serviceManagedEc2);
        }

        public final CustomerManagedFleetConfiguration.Builder getCustomerManaged() {
            return this.customerManaged != null ? this.customerManaged.toBuilder() : null;
        }

        public final void setCustomerManaged(CustomerManagedFleetConfiguration.BuilderImpl customerManaged) {
            CustomerManagedFleetConfiguration oldValue = this.customerManaged;
            this.customerManaged = customerManaged != null ? customerManaged.build() : null;
            this.handleUnionValueChange(Type.CUSTOMER_MANAGED, oldValue, this.customerManaged);
        }

        @Override
        public final Builder customerManaged(CustomerManagedFleetConfiguration customerManaged) {
            CustomerManagedFleetConfiguration oldValue = this.customerManaged;
            this.customerManaged = customerManaged;
            this.handleUnionValueChange(Type.CUSTOMER_MANAGED, oldValue, this.customerManaged);
            return this;
        }

        public final ServiceManagedEc2FleetConfiguration.Builder getServiceManagedEc2() {
            return this.serviceManagedEc2 != null ? this.serviceManagedEc2.toBuilder() : null;
        }

        public final void setServiceManagedEc2(ServiceManagedEc2FleetConfiguration.BuilderImpl serviceManagedEc2) {
            ServiceManagedEc2FleetConfiguration oldValue = this.serviceManagedEc2;
            this.serviceManagedEc2 = serviceManagedEc2 != null ? serviceManagedEc2.build() : null;
            this.handleUnionValueChange(Type.SERVICE_MANAGED_EC2, oldValue, this.serviceManagedEc2);
        }

        @Override
        public final Builder serviceManagedEc2(ServiceManagedEc2FleetConfiguration serviceManagedEc2) {
            ServiceManagedEc2FleetConfiguration oldValue = this.serviceManagedEc2;
            this.serviceManagedEc2 = serviceManagedEc2;
            this.handleUnionValueChange(Type.SERVICE_MANAGED_EC2, oldValue, this.serviceManagedEc2);
            return this;
        }

        public FleetConfiguration build() {
            return new FleetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetConfiguration> {
        public Builder customerManaged(CustomerManagedFleetConfiguration var1);

        default public Builder customerManaged(Consumer<CustomerManagedFleetConfiguration.Builder> customerManaged) {
            return this.customerManaged((CustomerManagedFleetConfiguration)((CustomerManagedFleetConfiguration.Builder)CustomerManagedFleetConfiguration.builder().applyMutation(customerManaged)).build());
        }

        public Builder serviceManagedEc2(ServiceManagedEc2FleetConfiguration var1);

        default public Builder serviceManagedEc2(Consumer<ServiceManagedEc2FleetConfiguration.Builder> serviceManagedEc2) {
            return this.serviceManagedEc2((ServiceManagedEc2FleetConfiguration)((ServiceManagedEc2FleetConfiguration.Builder)ServiceManagedEc2FleetConfiguration.builder().applyMutation(serviceManagedEc2)).build());
        }
    }
}

