/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.EnvironmentDetailsIdentifiers;
import software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsIdentifiers;
import software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers;
import software.amazon.awssdk.services.deadline.model.StepDetailsIdentifiers;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobEntityIdentifiersUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobEntityIdentifiersUnion> {
    private static final SdkField<JobDetailsIdentifiers> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDetails").getter(JobEntityIdentifiersUnion.getter(JobEntityIdentifiersUnion::jobDetails)).setter(JobEntityIdentifiersUnion.setter(Builder::jobDetails)).constructor(JobDetailsIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()}).build();
    private static final SdkField<JobAttachmentDetailsIdentifiers> JOB_ATTACHMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentDetails").getter(JobEntityIdentifiersUnion.getter(JobEntityIdentifiersUnion::jobAttachmentDetails)).setter(JobEntityIdentifiersUnion.setter(Builder::jobAttachmentDetails)).constructor(JobAttachmentDetailsIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build()}).build();
    private static final SdkField<StepDetailsIdentifiers> STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepDetails").getter(JobEntityIdentifiersUnion.getter(JobEntityIdentifiersUnion::stepDetails)).setter(JobEntityIdentifiersUnion.setter(Builder::stepDetails)).constructor(StepDetailsIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()}).build();
    private static final SdkField<EnvironmentDetailsIdentifiers> ENVIRONMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentDetails").getter(JobEntityIdentifiersUnion.getter(JobEntityIdentifiersUnion::environmentDetails)).setter(JobEntityIdentifiersUnion.setter(Builder::environmentDetails)).constructor(EnvironmentDetailsIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD, JOB_ATTACHMENT_DETAILS_FIELD, STEP_DETAILS_FIELD, ENVIRONMENT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final JobDetailsIdentifiers jobDetails;
    private final JobAttachmentDetailsIdentifiers jobAttachmentDetails;
    private final StepDetailsIdentifiers stepDetails;
    private final EnvironmentDetailsIdentifiers environmentDetails;
    private final Type type;

    private JobEntityIdentifiersUnion(BuilderImpl builder) {
        this.jobDetails = builder.jobDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.stepDetails = builder.stepDetails;
        this.environmentDetails = builder.environmentDetails;
        this.type = builder.type;
    }

    public final JobDetailsIdentifiers jobDetails() {
        return this.jobDetails;
    }

    public final JobAttachmentDetailsIdentifiers jobAttachmentDetails() {
        return this.jobAttachmentDetails;
    }

    public final StepDetailsIdentifiers stepDetails() {
        return this.stepDetails;
    }

    public final EnvironmentDetailsIdentifiers environmentDetails() {
        return this.environmentDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEntityIdentifiersUnion)) {
            return false;
        }
        JobEntityIdentifiersUnion other = (JobEntityIdentifiersUnion)obj;
        return Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.jobAttachmentDetails(), other.jobAttachmentDetails()) && Objects.equals(this.stepDetails(), other.stepDetails()) && Objects.equals(this.environmentDetails(), other.environmentDetails());
    }

    public final String toString() {
        return ToString.builder((String)"JobEntityIdentifiersUnion").add("JobDetails", (Object)this.jobDetails()).add("JobAttachmentDetails", (Object)this.jobAttachmentDetails()).add("StepDetails", (Object)this.stepDetails()).add("EnvironmentDetails", (Object)this.environmentDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "jobAttachmentDetails": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentDetails()));
            }
            case "stepDetails": {
                return Optional.ofNullable(clazz.cast(this.stepDetails()));
            }
            case "environmentDetails": {
                return Optional.ofNullable(clazz.cast(this.environmentDetails()));
            }
        }
        return Optional.empty();
    }

    public static JobEntityIdentifiersUnion fromJobDetails(JobDetailsIdentifiers jobDetails) {
        return (JobEntityIdentifiersUnion)JobEntityIdentifiersUnion.builder().jobDetails(jobDetails).build();
    }

    public static JobEntityIdentifiersUnion fromJobDetails(Consumer<JobDetailsIdentifiers.Builder> jobDetails) {
        JobDetailsIdentifiers.Builder builder = JobDetailsIdentifiers.builder();
        jobDetails.accept(builder);
        return JobEntityIdentifiersUnion.fromJobDetails((JobDetailsIdentifiers)builder.build());
    }

    public static JobEntityIdentifiersUnion fromJobAttachmentDetails(JobAttachmentDetailsIdentifiers jobAttachmentDetails) {
        return (JobEntityIdentifiersUnion)JobEntityIdentifiersUnion.builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    public static JobEntityIdentifiersUnion fromJobAttachmentDetails(Consumer<JobAttachmentDetailsIdentifiers.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsIdentifiers.Builder builder = JobAttachmentDetailsIdentifiers.builder();
        jobAttachmentDetails.accept(builder);
        return JobEntityIdentifiersUnion.fromJobAttachmentDetails((JobAttachmentDetailsIdentifiers)builder.build());
    }

    public static JobEntityIdentifiersUnion fromStepDetails(StepDetailsIdentifiers stepDetails) {
        return (JobEntityIdentifiersUnion)JobEntityIdentifiersUnion.builder().stepDetails(stepDetails).build();
    }

    public static JobEntityIdentifiersUnion fromStepDetails(Consumer<StepDetailsIdentifiers.Builder> stepDetails) {
        StepDetailsIdentifiers.Builder builder = StepDetailsIdentifiers.builder();
        stepDetails.accept(builder);
        return JobEntityIdentifiersUnion.fromStepDetails((StepDetailsIdentifiers)builder.build());
    }

    public static JobEntityIdentifiersUnion fromEnvironmentDetails(EnvironmentDetailsIdentifiers environmentDetails) {
        return (JobEntityIdentifiersUnion)JobEntityIdentifiersUnion.builder().environmentDetails(environmentDetails).build();
    }

    public static JobEntityIdentifiersUnion fromEnvironmentDetails(Consumer<EnvironmentDetailsIdentifiers.Builder> environmentDetails) {
        EnvironmentDetailsIdentifiers.Builder builder = EnvironmentDetailsIdentifiers.builder();
        environmentDetails.accept(builder);
        return JobEntityIdentifiersUnion.fromEnvironmentDetails((EnvironmentDetailsIdentifiers)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobEntityIdentifiersUnion, T> g) {
        return obj -> g.apply((JobEntityIdentifiersUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        JOB_DETAILS,
        JOB_ATTACHMENT_DETAILS,
        STEP_DETAILS,
        ENVIRONMENT_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private JobDetailsIdentifiers jobDetails;
        private JobAttachmentDetailsIdentifiers jobAttachmentDetails;
        private StepDetailsIdentifiers stepDetails;
        private EnvironmentDetailsIdentifiers environmentDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobEntityIdentifiersUnion model) {
            this.jobDetails(model.jobDetails);
            this.jobAttachmentDetails(model.jobAttachmentDetails);
            this.stepDetails(model.stepDetails);
            this.environmentDetails(model.environmentDetails);
        }

        public final JobDetailsIdentifiers.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsIdentifiers.BuilderImpl jobDetails) {
            JobDetailsIdentifiers oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsIdentifiers jobDetails) {
            JobDetailsIdentifiers oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final JobAttachmentDetailsIdentifiers.Builder getJobAttachmentDetails() {
            return this.jobAttachmentDetails != null ? this.jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsIdentifiers.BuilderImpl jobAttachmentDetails) {
            JobAttachmentDetailsIdentifiers oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsIdentifiers jobAttachmentDetails) {
            JobAttachmentDetailsIdentifiers oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final StepDetailsIdentifiers.Builder getStepDetails() {
            return this.stepDetails != null ? this.stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsIdentifiers.BuilderImpl stepDetails) {
            StepDetailsIdentifiers oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsIdentifiers stepDetails) {
            StepDetailsIdentifiers oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public final EnvironmentDetailsIdentifiers.Builder getEnvironmentDetails() {
            return this.environmentDetails != null ? this.environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsIdentifiers.BuilderImpl environmentDetails) {
            EnvironmentDetailsIdentifiers oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsIdentifiers environmentDetails) {
            EnvironmentDetailsIdentifiers oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        public JobEntityIdentifiersUnion build() {
            return new JobEntityIdentifiersUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobEntityIdentifiersUnion> {
        public Builder jobDetails(JobDetailsIdentifiers var1);

        default public Builder jobDetails(Consumer<JobDetailsIdentifiers.Builder> jobDetails) {
            return this.jobDetails((JobDetailsIdentifiers)((JobDetailsIdentifiers.Builder)JobDetailsIdentifiers.builder().applyMutation(jobDetails)).build());
        }

        public Builder jobAttachmentDetails(JobAttachmentDetailsIdentifiers var1);

        default public Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsIdentifiers.Builder> jobAttachmentDetails) {
            return this.jobAttachmentDetails((JobAttachmentDetailsIdentifiers)((JobAttachmentDetailsIdentifiers.Builder)JobAttachmentDetailsIdentifiers.builder().applyMutation(jobAttachmentDetails)).build());
        }

        public Builder stepDetails(StepDetailsIdentifiers var1);

        default public Builder stepDetails(Consumer<StepDetailsIdentifiers.Builder> stepDetails) {
            return this.stepDetails((StepDetailsIdentifiers)((StepDetailsIdentifiers.Builder)StepDetailsIdentifiers.builder().applyMutation(stepDetails)).build());
        }

        public Builder environmentDetails(EnvironmentDetailsIdentifiers var1);

        default public Builder environmentDetails(Consumer<EnvironmentDetailsIdentifiers.Builder> environmentDetails) {
            return this.environmentDetails((EnvironmentDetailsIdentifiers)((EnvironmentDetailsIdentifiers.Builder)EnvironmentDetailsIdentifiers.builder().applyMutation(environmentDetails)).build());
        }
    }
}

