/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummary;

public class ListMeteredProductsIterable
implements SdkIterable<ListMeteredProductsResponse> {
    private final DeadlineClient client;
    private final ListMeteredProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMeteredProductsIterable(DeadlineClient client, ListMeteredProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMeteredProductsResponseFetcher();
    }

    public Iterator<ListMeteredProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MeteredProductSummary> meteredProducts() {
        Function<ListMeteredProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.meteredProducts() != null) {
                return response.meteredProducts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMeteredProductsResponseFetcher
    implements SyncPageFetcher<ListMeteredProductsResponse> {
        private ListMeteredProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListMeteredProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMeteredProductsResponse nextPage(ListMeteredProductsResponse previousPage) {
            if (previousPage == null) {
                return ListMeteredProductsIterable.this.client.listMeteredProducts(ListMeteredProductsIterable.this.firstRequest);
            }
            return ListMeteredProductsIterable.this.client.listMeteredProducts((ListMeteredProductsRequest)((Object)ListMeteredProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

