/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.Stats;
import software.amazon.awssdk.services.deadline.model.UsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Statistics> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(Statistics.getter(Statistics::queueId)).setter(Statistics.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(Statistics.getter(Statistics::fleetId)).setter(Statistics.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(Statistics.getter(Statistics::jobId)).setter(Statistics.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(Statistics.getter(Statistics::jobName)).setter(Statistics.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(Statistics.getter(Statistics::userId)).setter(Statistics.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(Statistics.getter(Statistics::usageTypeAsString)).setter(Statistics.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> LICENSE_PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseProduct").getter(Statistics.getter(Statistics::licenseProduct)).setter(Statistics.setter(Builder::licenseProduct)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseProduct").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(Statistics.getter(Statistics::instanceType)).setter(Statistics.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(Statistics.getter(Statistics::count)).setter(Statistics.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Stats> COST_IN_USD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costInUsd").getter(Statistics.getter(Statistics::costInUsd)).setter(Statistics.setter(Builder::costInUsd)).constructor(Stats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costInUsd").build()}).build();
    private static final SdkField<Stats> RUNTIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtimeInSeconds").getter(Statistics.getter(Statistics::runtimeInSeconds)).setter(Statistics.setter(Builder::runtimeInSeconds)).constructor(Stats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeInSeconds").build()}).build();
    private static final SdkField<Instant> AGGREGATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("aggregationStartTime").getter(Statistics.getter(Statistics::aggregationStartTime)).setter(Statistics.setter(Builder::aggregationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> AGGREGATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("aggregationEndTime").getter(Statistics.getter(Statistics::aggregationEndTime)).setter(Statistics.setter(Builder::aggregationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, FLEET_ID_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, USER_ID_FIELD, USAGE_TYPE_FIELD, LICENSE_PRODUCT_FIELD, INSTANCE_TYPE_FIELD, COUNT_FIELD, COST_IN_USD_FIELD, RUNTIME_IN_SECONDS_FIELD, AGGREGATION_START_TIME_FIELD, AGGREGATION_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("queueId", QUEUE_ID_FIELD);
            this.put("fleetId", FLEET_ID_FIELD);
            this.put("jobId", JOB_ID_FIELD);
            this.put("jobName", JOB_NAME_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("usageType", USAGE_TYPE_FIELD);
            this.put("licenseProduct", LICENSE_PRODUCT_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("count", COUNT_FIELD);
            this.put("costInUsd", COST_IN_USD_FIELD);
            this.put("runtimeInSeconds", RUNTIME_IN_SECONDS_FIELD);
            this.put("aggregationStartTime", AGGREGATION_START_TIME_FIELD);
            this.put("aggregationEndTime", AGGREGATION_END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String queueId;
    private final String fleetId;
    private final String jobId;
    private final String jobName;
    private final String userId;
    private final String usageType;
    private final String licenseProduct;
    private final String instanceType;
    private final Integer count;
    private final Stats costInUsd;
    private final Stats runtimeInSeconds;
    private final Instant aggregationStartTime;
    private final Instant aggregationEndTime;

    private Statistics(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.fleetId = builder.fleetId;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.userId = builder.userId;
        this.usageType = builder.usageType;
        this.licenseProduct = builder.licenseProduct;
        this.instanceType = builder.instanceType;
        this.count = builder.count;
        this.costInUsd = builder.costInUsd;
        this.runtimeInSeconds = builder.runtimeInSeconds;
        this.aggregationStartTime = builder.aggregationStartTime;
        this.aggregationEndTime = builder.aggregationEndTime;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String userId() {
        return this.userId;
    }

    public final UsageType usageType() {
        return UsageType.fromValue(this.usageType);
    }

    public final String usageTypeAsString() {
        return this.usageType;
    }

    public final String licenseProduct() {
        return this.licenseProduct;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer count() {
        return this.count;
    }

    public final Stats costInUsd() {
        return this.costInUsd;
    }

    public final Stats runtimeInSeconds() {
        return this.runtimeInSeconds;
    }

    public final Instant aggregationStartTime() {
        return this.aggregationStartTime;
    }

    public final Instant aggregationEndTime() {
        return this.aggregationEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseProduct());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.costInUsd());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics)obj;
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.usageTypeAsString(), other.usageTypeAsString()) && Objects.equals(this.licenseProduct(), other.licenseProduct()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.costInUsd(), other.costInUsd()) && Objects.equals(this.runtimeInSeconds(), other.runtimeInSeconds()) && Objects.equals(this.aggregationStartTime(), other.aggregationStartTime()) && Objects.equals(this.aggregationEndTime(), other.aggregationEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"Statistics").add("QueueId", (Object)this.queueId()).add("FleetId", (Object)this.fleetId()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("UserId", (Object)this.userId()).add("UsageType", (Object)this.usageTypeAsString()).add("LicenseProduct", (Object)this.licenseProduct()).add("InstanceType", (Object)this.instanceType()).add("Count", (Object)this.count()).add("CostInUsd", (Object)this.costInUsd()).add("RuntimeInSeconds", (Object)this.runtimeInSeconds()).add("AggregationStartTime", (Object)this.aggregationStartTime()).add("AggregationEndTime", (Object)this.aggregationEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageTypeAsString()));
            }
            case "licenseProduct": {
                return Optional.ofNullable(clazz.cast(this.licenseProduct()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "costInUsd": {
                return Optional.ofNullable(clazz.cast(this.costInUsd()));
            }
            case "runtimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.runtimeInSeconds()));
            }
            case "aggregationStartTime": {
                return Optional.ofNullable(clazz.cast(this.aggregationStartTime()));
            }
            case "aggregationEndTime": {
                return Optional.ofNullable(clazz.cast(this.aggregationEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queueId;
        private String fleetId;
        private String jobId;
        private String jobName;
        private String userId;
        private String usageType;
        private String licenseProduct;
        private String instanceType;
        private Integer count;
        private Stats costInUsd;
        private Stats runtimeInSeconds;
        private Instant aggregationStartTime;
        private Instant aggregationEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            this.queueId(model.queueId);
            this.fleetId(model.fleetId);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.userId(model.userId);
            this.usageType(model.usageType);
            this.licenseProduct(model.licenseProduct);
            this.instanceType(model.instanceType);
            this.count(model.count);
            this.costInUsd(model.costInUsd);
            this.runtimeInSeconds(model.runtimeInSeconds);
            this.aggregationStartTime(model.aggregationStartTime);
            this.aggregationEndTime(model.aggregationEndTime);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        public final String getLicenseProduct() {
            return this.licenseProduct;
        }

        public final void setLicenseProduct(String licenseProduct) {
            this.licenseProduct = licenseProduct;
        }

        @Override
        public final Builder licenseProduct(String licenseProduct) {
            this.licenseProduct = licenseProduct;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Stats.Builder getCostInUsd() {
            return this.costInUsd != null ? this.costInUsd.toBuilder() : null;
        }

        public final void setCostInUsd(Stats.BuilderImpl costInUsd) {
            this.costInUsd = costInUsd != null ? costInUsd.build() : null;
        }

        @Override
        public final Builder costInUsd(Stats costInUsd) {
            this.costInUsd = costInUsd;
            return this;
        }

        public final Stats.Builder getRuntimeInSeconds() {
            return this.runtimeInSeconds != null ? this.runtimeInSeconds.toBuilder() : null;
        }

        public final void setRuntimeInSeconds(Stats.BuilderImpl runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds != null ? runtimeInSeconds.build() : null;
        }

        @Override
        public final Builder runtimeInSeconds(Stats runtimeInSeconds) {
            this.runtimeInSeconds = runtimeInSeconds;
            return this;
        }

        public final Instant getAggregationStartTime() {
            return this.aggregationStartTime;
        }

        public final void setAggregationStartTime(Instant aggregationStartTime) {
            this.aggregationStartTime = aggregationStartTime;
        }

        @Override
        public final Builder aggregationStartTime(Instant aggregationStartTime) {
            this.aggregationStartTime = aggregationStartTime;
            return this;
        }

        public final Instant getAggregationEndTime() {
            return this.aggregationEndTime;
        }

        public final void setAggregationEndTime(Instant aggregationEndTime) {
            this.aggregationEndTime = aggregationEndTime;
        }

        @Override
        public final Builder aggregationEndTime(Instant aggregationEndTime) {
            this.aggregationEndTime = aggregationEndTime;
            return this;
        }

        public Statistics build() {
            return new Statistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Statistics> {
        public Builder queueId(String var1);

        public Builder fleetId(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder userId(String var1);

        public Builder usageType(String var1);

        public Builder usageType(UsageType var1);

        public Builder licenseProduct(String var1);

        public Builder instanceType(String var1);

        public Builder count(Integer var1);

        public Builder costInUsd(Stats var1);

        default public Builder costInUsd(Consumer<Stats.Builder> costInUsd) {
            return this.costInUsd((Stats)((Stats.Builder)Stats.builder().applyMutation(costInUsd)).build());
        }

        public Builder runtimeInSeconds(Stats var1);

        default public Builder runtimeInSeconds(Consumer<Stats.Builder> runtimeInSeconds) {
            return this.runtimeInSeconds((Stats)((Stats.Builder)Stats.builder().applyMutation(runtimeInSeconds)).build());
        }

        public Builder aggregationStartTime(Instant var1);

        public Builder aggregationEndTime(Instant var1);
    }
}

