/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.DateTimeFilterExpression;
import software.amazon.awssdk.services.deadline.model.ParameterFilterExpression;
import software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions;
import software.amazon.awssdk.services.deadline.model.SearchTermFilterExpression;
import software.amazon.awssdk.services.deadline.model.StringFilterExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchFilterExpression> {
    private static final SdkField<DateTimeFilterExpression> DATE_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dateTimeFilter").getter(SearchFilterExpression.getter(SearchFilterExpression::dateTimeFilter)).setter(SearchFilterExpression.setter(Builder::dateTimeFilter)).constructor(DateTimeFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTimeFilter").build()}).build();
    private static final SdkField<ParameterFilterExpression> PARAMETER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameterFilter").getter(SearchFilterExpression.getter(SearchFilterExpression::parameterFilter)).setter(SearchFilterExpression.setter(Builder::parameterFilter)).constructor(ParameterFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterFilter").build()}).build();
    private static final SdkField<SearchTermFilterExpression> SEARCH_TERM_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("searchTermFilter").getter(SearchFilterExpression.getter(SearchFilterExpression::searchTermFilter)).setter(SearchFilterExpression.setter(Builder::searchTermFilter)).constructor(SearchTermFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTermFilter").build()}).build();
    private static final SdkField<StringFilterExpression> STRING_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stringFilter").getter(SearchFilterExpression.getter(SearchFilterExpression::stringFilter)).setter(SearchFilterExpression.setter(Builder::stringFilter)).constructor(StringFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringFilter").build()}).build();
    private static final SdkField<SearchGroupedFilterExpressions> GROUP_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupFilter").getter(SearchFilterExpression.getter(SearchFilterExpression::groupFilter)).setter(SearchFilterExpression.setter(Builder::groupFilter)).constructor(SearchGroupedFilterExpressions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_FILTER_FIELD, PARAMETER_FILTER_FIELD, SEARCH_TERM_FILTER_FIELD, STRING_FILTER_FIELD, GROUP_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final DateTimeFilterExpression dateTimeFilter;
    private final ParameterFilterExpression parameterFilter;
    private final SearchTermFilterExpression searchTermFilter;
    private final StringFilterExpression stringFilter;
    private final SearchGroupedFilterExpressions groupFilter;
    private final Type type;

    private SearchFilterExpression(BuilderImpl builder) {
        this.dateTimeFilter = builder.dateTimeFilter;
        this.parameterFilter = builder.parameterFilter;
        this.searchTermFilter = builder.searchTermFilter;
        this.stringFilter = builder.stringFilter;
        this.groupFilter = builder.groupFilter;
        this.type = builder.type;
    }

    public final DateTimeFilterExpression dateTimeFilter() {
        return this.dateTimeFilter;
    }

    public final ParameterFilterExpression parameterFilter() {
        return this.parameterFilter;
    }

    public final SearchTermFilterExpression searchTermFilter() {
        return this.searchTermFilter;
    }

    public final StringFilterExpression stringFilter() {
        return this.stringFilter;
    }

    public final SearchGroupedFilterExpressions groupFilter() {
        return this.groupFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchTermFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFilterExpression)) {
            return false;
        }
        SearchFilterExpression other = (SearchFilterExpression)obj;
        return Objects.equals(this.dateTimeFilter(), other.dateTimeFilter()) && Objects.equals(this.parameterFilter(), other.parameterFilter()) && Objects.equals(this.searchTermFilter(), other.searchTermFilter()) && Objects.equals(this.stringFilter(), other.stringFilter()) && Objects.equals(this.groupFilter(), other.groupFilter());
    }

    public final String toString() {
        return ToString.builder((String)"SearchFilterExpression").add("DateTimeFilter", (Object)this.dateTimeFilter()).add("ParameterFilter", (Object)this.parameterFilter()).add("SearchTermFilter", (Object)this.searchTermFilter()).add("StringFilter", (Object)this.stringFilter()).add("GroupFilter", (Object)this.groupFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dateTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.dateTimeFilter()));
            }
            case "parameterFilter": {
                return Optional.ofNullable(clazz.cast(this.parameterFilter()));
            }
            case "searchTermFilter": {
                return Optional.ofNullable(clazz.cast(this.searchTermFilter()));
            }
            case "stringFilter": {
                return Optional.ofNullable(clazz.cast(this.stringFilter()));
            }
            case "groupFilter": {
                return Optional.ofNullable(clazz.cast(this.groupFilter()));
            }
        }
        return Optional.empty();
    }

    public static SearchFilterExpression fromDateTimeFilter(DateTimeFilterExpression dateTimeFilter) {
        return (SearchFilterExpression)SearchFilterExpression.builder().dateTimeFilter(dateTimeFilter).build();
    }

    public static SearchFilterExpression fromDateTimeFilter(Consumer<DateTimeFilterExpression.Builder> dateTimeFilter) {
        DateTimeFilterExpression.Builder builder = DateTimeFilterExpression.builder();
        dateTimeFilter.accept(builder);
        return SearchFilterExpression.fromDateTimeFilter((DateTimeFilterExpression)builder.build());
    }

    public static SearchFilterExpression fromParameterFilter(ParameterFilterExpression parameterFilter) {
        return (SearchFilterExpression)SearchFilterExpression.builder().parameterFilter(parameterFilter).build();
    }

    public static SearchFilterExpression fromParameterFilter(Consumer<ParameterFilterExpression.Builder> parameterFilter) {
        ParameterFilterExpression.Builder builder = ParameterFilterExpression.builder();
        parameterFilter.accept(builder);
        return SearchFilterExpression.fromParameterFilter((ParameterFilterExpression)builder.build());
    }

    public static SearchFilterExpression fromSearchTermFilter(SearchTermFilterExpression searchTermFilter) {
        return (SearchFilterExpression)SearchFilterExpression.builder().searchTermFilter(searchTermFilter).build();
    }

    public static SearchFilterExpression fromSearchTermFilter(Consumer<SearchTermFilterExpression.Builder> searchTermFilter) {
        SearchTermFilterExpression.Builder builder = SearchTermFilterExpression.builder();
        searchTermFilter.accept(builder);
        return SearchFilterExpression.fromSearchTermFilter((SearchTermFilterExpression)builder.build());
    }

    public static SearchFilterExpression fromStringFilter(StringFilterExpression stringFilter) {
        return (SearchFilterExpression)SearchFilterExpression.builder().stringFilter(stringFilter).build();
    }

    public static SearchFilterExpression fromStringFilter(Consumer<StringFilterExpression.Builder> stringFilter) {
        StringFilterExpression.Builder builder = StringFilterExpression.builder();
        stringFilter.accept(builder);
        return SearchFilterExpression.fromStringFilter((StringFilterExpression)builder.build());
    }

    public static SearchFilterExpression fromGroupFilter(SearchGroupedFilterExpressions groupFilter) {
        return (SearchFilterExpression)SearchFilterExpression.builder().groupFilter(groupFilter).build();
    }

    public static SearchFilterExpression fromGroupFilter(Consumer<SearchGroupedFilterExpressions.Builder> groupFilter) {
        SearchGroupedFilterExpressions.Builder builder = SearchGroupedFilterExpressions.builder();
        groupFilter.accept(builder);
        return SearchFilterExpression.fromGroupFilter((SearchGroupedFilterExpressions)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFilterExpression, T> g) {
        return obj -> g.apply((SearchFilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATE_TIME_FILTER,
        PARAMETER_FILTER,
        SEARCH_TERM_FILTER,
        STRING_FILTER,
        GROUP_FILTER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DateTimeFilterExpression dateTimeFilter;
        private ParameterFilterExpression parameterFilter;
        private SearchTermFilterExpression searchTermFilter;
        private StringFilterExpression stringFilter;
        private SearchGroupedFilterExpressions groupFilter;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFilterExpression model) {
            this.dateTimeFilter(model.dateTimeFilter);
            this.parameterFilter(model.parameterFilter);
            this.searchTermFilter(model.searchTermFilter);
            this.stringFilter(model.stringFilter);
            this.groupFilter(model.groupFilter);
        }

        public final DateTimeFilterExpression.Builder getDateTimeFilter() {
            return this.dateTimeFilter != null ? this.dateTimeFilter.toBuilder() : null;
        }

        public final void setDateTimeFilter(DateTimeFilterExpression.BuilderImpl dateTimeFilter) {
            DateTimeFilterExpression oldValue = this.dateTimeFilter;
            this.dateTimeFilter = dateTimeFilter != null ? dateTimeFilter.build() : null;
            this.handleUnionValueChange(Type.DATE_TIME_FILTER, oldValue, this.dateTimeFilter);
        }

        @Override
        public final Builder dateTimeFilter(DateTimeFilterExpression dateTimeFilter) {
            DateTimeFilterExpression oldValue = this.dateTimeFilter;
            this.dateTimeFilter = dateTimeFilter;
            this.handleUnionValueChange(Type.DATE_TIME_FILTER, oldValue, this.dateTimeFilter);
            return this;
        }

        public final ParameterFilterExpression.Builder getParameterFilter() {
            return this.parameterFilter != null ? this.parameterFilter.toBuilder() : null;
        }

        public final void setParameterFilter(ParameterFilterExpression.BuilderImpl parameterFilter) {
            ParameterFilterExpression oldValue = this.parameterFilter;
            this.parameterFilter = parameterFilter != null ? parameterFilter.build() : null;
            this.handleUnionValueChange(Type.PARAMETER_FILTER, oldValue, this.parameterFilter);
        }

        @Override
        public final Builder parameterFilter(ParameterFilterExpression parameterFilter) {
            ParameterFilterExpression oldValue = this.parameterFilter;
            this.parameterFilter = parameterFilter;
            this.handleUnionValueChange(Type.PARAMETER_FILTER, oldValue, this.parameterFilter);
            return this;
        }

        public final SearchTermFilterExpression.Builder getSearchTermFilter() {
            return this.searchTermFilter != null ? this.searchTermFilter.toBuilder() : null;
        }

        public final void setSearchTermFilter(SearchTermFilterExpression.BuilderImpl searchTermFilter) {
            SearchTermFilterExpression oldValue = this.searchTermFilter;
            this.searchTermFilter = searchTermFilter != null ? searchTermFilter.build() : null;
            this.handleUnionValueChange(Type.SEARCH_TERM_FILTER, oldValue, this.searchTermFilter);
        }

        @Override
        public final Builder searchTermFilter(SearchTermFilterExpression searchTermFilter) {
            SearchTermFilterExpression oldValue = this.searchTermFilter;
            this.searchTermFilter = searchTermFilter;
            this.handleUnionValueChange(Type.SEARCH_TERM_FILTER, oldValue, this.searchTermFilter);
            return this;
        }

        public final StringFilterExpression.Builder getStringFilter() {
            return this.stringFilter != null ? this.stringFilter.toBuilder() : null;
        }

        public final void setStringFilter(StringFilterExpression.BuilderImpl stringFilter) {
            StringFilterExpression oldValue = this.stringFilter;
            this.stringFilter = stringFilter != null ? stringFilter.build() : null;
            this.handleUnionValueChange(Type.STRING_FILTER, oldValue, this.stringFilter);
        }

        @Override
        public final Builder stringFilter(StringFilterExpression stringFilter) {
            StringFilterExpression oldValue = this.stringFilter;
            this.stringFilter = stringFilter;
            this.handleUnionValueChange(Type.STRING_FILTER, oldValue, this.stringFilter);
            return this;
        }

        public final SearchGroupedFilterExpressions.Builder getGroupFilter() {
            return this.groupFilter != null ? this.groupFilter.toBuilder() : null;
        }

        public final void setGroupFilter(SearchGroupedFilterExpressions.BuilderImpl groupFilter) {
            SearchGroupedFilterExpressions oldValue = this.groupFilter;
            this.groupFilter = groupFilter != null ? groupFilter.build() : null;
            this.handleUnionValueChange(Type.GROUP_FILTER, oldValue, this.groupFilter);
        }

        @Override
        public final Builder groupFilter(SearchGroupedFilterExpressions groupFilter) {
            SearchGroupedFilterExpressions oldValue = this.groupFilter;
            this.groupFilter = groupFilter;
            this.handleUnionValueChange(Type.GROUP_FILTER, oldValue, this.groupFilter);
            return this;
        }

        public SearchFilterExpression build() {
            return new SearchFilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchFilterExpression> {
        public Builder dateTimeFilter(DateTimeFilterExpression var1);

        default public Builder dateTimeFilter(Consumer<DateTimeFilterExpression.Builder> dateTimeFilter) {
            return this.dateTimeFilter((DateTimeFilterExpression)((DateTimeFilterExpression.Builder)DateTimeFilterExpression.builder().applyMutation(dateTimeFilter)).build());
        }

        public Builder parameterFilter(ParameterFilterExpression var1);

        default public Builder parameterFilter(Consumer<ParameterFilterExpression.Builder> parameterFilter) {
            return this.parameterFilter((ParameterFilterExpression)((ParameterFilterExpression.Builder)ParameterFilterExpression.builder().applyMutation(parameterFilter)).build());
        }

        public Builder searchTermFilter(SearchTermFilterExpression var1);

        default public Builder searchTermFilter(Consumer<SearchTermFilterExpression.Builder> searchTermFilter) {
            return this.searchTermFilter((SearchTermFilterExpression)((SearchTermFilterExpression.Builder)SearchTermFilterExpression.builder().applyMutation(searchTermFilter)).build());
        }

        public Builder stringFilter(StringFilterExpression var1);

        default public Builder stringFilter(Consumer<StringFilterExpression.Builder> stringFilter) {
            return this.stringFilter((StringFilterExpression)((StringFilterExpression.Builder)StringFilterExpression.builder().applyMutation(stringFilter)).build());
        }

        public Builder groupFilter(SearchGroupedFilterExpressions var1);

        default public Builder groupFilter(Consumer<SearchGroupedFilterExpressions.Builder> groupFilter) {
            return this.groupFilter((SearchGroupedFilterExpressions)((SearchGroupedFilterExpressions.Builder)SearchGroupedFilterExpressions.builder().applyMutation(groupFilter)).build());
        }
    }
}

