/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummary;

public class ListStorageProfilesIterable
implements SdkIterable<ListStorageProfilesResponse> {
    private final DeadlineClient client;
    private final ListStorageProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageProfilesIterable(DeadlineClient client, ListStorageProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStorageProfilesResponseFetcher();
    }

    public Iterator<ListStorageProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StorageProfileSummary> storageProfiles() {
        Function<ListStorageProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageProfiles() != null) {
                return response.storageProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStorageProfilesResponseFetcher
    implements SyncPageFetcher<ListStorageProfilesResponse> {
        private ListStorageProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageProfilesResponse nextPage(ListStorageProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListStorageProfilesIterable.this.client.listStorageProfiles(ListStorageProfilesIterable.this.firstRequest);
            }
            return ListStorageProfilesIterable.this.client.listStorageProfiles((ListStorageProfilesRequest)((Object)ListStorageProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

