/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.WorkerSessionSummary;

public class ListSessionsForWorkerPublisher
implements SdkPublisher<ListSessionsForWorkerResponse> {
    private final DeadlineAsyncClient client;
    private final ListSessionsForWorkerRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionsForWorkerPublisher(DeadlineAsyncClient client, ListSessionsForWorkerRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionsForWorkerPublisher(DeadlineAsyncClient client, ListSessionsForWorkerRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionsForWorkerResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionsForWorkerResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkerSessionSummary> sessions() {
        Function<ListSessionsForWorkerResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSessionsForWorkerResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSessionsForWorkerResponseFetcher
    implements AsyncPageFetcher<ListSessionsForWorkerResponse> {
        private ListSessionsForWorkerResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsForWorkerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionsForWorkerResponse> nextPage(ListSessionsForWorkerResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsForWorkerPublisher.this.client.listSessionsForWorker(ListSessionsForWorkerPublisher.this.firstRequest);
            }
            return ListSessionsForWorkerPublisher.this.client.listSessionsForWorker((ListSessionsForWorkerRequest)((Object)ListSessionsForWorkerPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

