/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStepsRequest;
import software.amazon.awssdk.services.deadline.model.ListStepsResponse;
import software.amazon.awssdk.services.deadline.model.StepSummary;

public class ListStepsIterable
implements SdkIterable<ListStepsResponse> {
    private final DeadlineClient client;
    private final ListStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStepsIterable(DeadlineClient client, ListStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStepsResponseFetcher();
    }

    public Iterator<ListStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StepSummary> steps() {
        Function<ListStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStepsResponseFetcher
    implements SyncPageFetcher<ListStepsResponse> {
        private ListStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStepsResponse nextPage(ListStepsResponse previousPage) {
            if (previousPage == null) {
                return ListStepsIterable.this.client.listSteps(ListStepsIterable.this.firstRequest);
            }
            return ListStepsIterable.this.client.listSteps((ListStepsRequest)((Object)ListStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

