/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.ComparisonOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeFilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeFilterExpression> {
    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateTime").getter(DateTimeFilterExpression.getter(DateTimeFilterExpression::dateTime)).setter(DateTimeFilterExpression.setter(Builder::dateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DateTimeFilterExpression.getter(DateTimeFilterExpression::name)).setter(DateTimeFilterExpression.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(DateTimeFilterExpression.getter(DateTimeFilterExpression::operatorAsString)).setter(DateTimeFilterExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_FIELD, NAME_FIELD, OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant dateTime;
    private final String name;
    private final String operator;

    private DateTimeFilterExpression(BuilderImpl builder) {
        this.dateTime = builder.dateTime;
        this.name = builder.name;
        this.operator = builder.operator;
    }

    public final Instant dateTime() {
        return this.dateTime;
    }

    public final String name() {
        return this.name;
    }

    public final ComparisonOperator operator() {
        return ComparisonOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeFilterExpression)) {
            return false;
        }
        DateTimeFilterExpression other = (DateTimeFilterExpression)obj;
        return Objects.equals(this.dateTime(), other.dateTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeFilterExpression").add("DateTime", (Object)this.dateTime()).add("Name", (Object)this.name()).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dateTime": {
                return Optional.ofNullable(clazz.cast(this.dateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeFilterExpression, T> g) {
        return obj -> g.apply((DateTimeFilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant dateTime;
        private String name;
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeFilterExpression model) {
            this.dateTime(model.dateTime);
            this.name(model.name);
            this.operator(model.operator);
        }

        public final Instant getDateTime() {
            return this.dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ComparisonOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public DateTimeFilterExpression build() {
            return new DateTimeFilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeFilterExpression> {
        public Builder dateTime(Instant var1);

        public Builder name(String var1);

        public Builder operator(String var1);

        public Builder operator(ComparisonOperator var1);
    }
}

