/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FarmSummary;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;

public class ListFarmsPublisher
implements SdkPublisher<ListFarmsResponse> {
    private final DeadlineAsyncClient client;
    private final ListFarmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFarmsPublisher(DeadlineAsyncClient client, ListFarmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFarmsPublisher(DeadlineAsyncClient client, ListFarmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFarmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFarmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FarmSummary> farms() {
        Function<ListFarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.farms() != null) {
                return response.farms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFarmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFarmsResponseFetcher
    implements AsyncPageFetcher<ListFarmsResponse> {
        private ListFarmsResponseFetcher() {
        }

        public boolean hasNextPage(ListFarmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFarmsResponse> nextPage(ListFarmsResponse previousPage) {
            if (previousPage == null) {
                return ListFarmsPublisher.this.client.listFarms(ListFarmsPublisher.this.firstRequest);
            }
            return ListFarmsPublisher.this.client.listFarms((ListFarmsRequest)((Object)ListFarmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

