/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.AutoScalingStatus;
import software.amazon.awssdk.services.deadline.model.FleetConfiguration;
import software.amazon.awssdk.services.deadline.model.FleetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetSummary> {
    private static final SdkField<String> AUTO_SCALING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingStatus").getter(FleetSummary.getter(FleetSummary::autoScalingStatusAsString)).setter(FleetSummary.setter(Builder::autoScalingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingStatus").build()}).build();
    private static final SdkField<FleetConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(FleetSummary.getter(FleetSummary::configuration)).setter(FleetSummary.setter(Builder::configuration)).constructor(FleetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FleetSummary.getter(FleetSummary::createdAt)).setter(FleetSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(FleetSummary.getter(FleetSummary::createdBy)).setter(FleetSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(FleetSummary.getter(FleetSummary::displayName)).setter(FleetSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(FleetSummary.getter(FleetSummary::farmId)).setter(FleetSummary.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(FleetSummary.getter(FleetSummary::fleetId)).setter(FleetSummary.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()}).build();
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxWorkerCount").getter(FleetSummary.getter(FleetSummary::maxWorkerCount)).setter(FleetSummary.setter(Builder::maxWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()}).build();
    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minWorkerCount").getter(FleetSummary.getter(FleetSummary::minWorkerCount)).setter(FleetSummary.setter(Builder::minWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FleetSummary.getter(FleetSummary::statusAsString)).setter(FleetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> TARGET_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetWorkerCount").getter(FleetSummary.getter(FleetSummary::targetWorkerCount)).setter(FleetSummary.setter(Builder::targetWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetWorkerCount").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(FleetSummary.getter(FleetSummary::updatedAt)).setter(FleetSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(FleetSummary.getter(FleetSummary::updatedBy)).setter(FleetSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<Integer> WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("workerCount").getter(FleetSummary.getter(FleetSummary::workerCount)).setter(FleetSummary.setter(Builder::workerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_STATUS_FIELD, CONFIGURATION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DISPLAY_NAME_FIELD, FARM_ID_FIELD, FLEET_ID_FIELD, MAX_WORKER_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, STATUS_FIELD, TARGET_WORKER_COUNT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, WORKER_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingStatus;
    private final FleetConfiguration configuration;
    private final Instant createdAt;
    private final String createdBy;
    private final String displayName;
    private final String farmId;
    private final String fleetId;
    private final Integer maxWorkerCount;
    private final Integer minWorkerCount;
    private final String status;
    private final Integer targetWorkerCount;
    private final Instant updatedAt;
    private final String updatedBy;
    private final Integer workerCount;

    private FleetSummary(BuilderImpl builder) {
        this.autoScalingStatus = builder.autoScalingStatus;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.status = builder.status;
        this.targetWorkerCount = builder.targetWorkerCount;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.workerCount = builder.workerCount;
    }

    public final AutoScalingStatus autoScalingStatus() {
        return AutoScalingStatus.fromValue(this.autoScalingStatus);
    }

    public final String autoScalingStatusAsString() {
        return this.autoScalingStatus;
    }

    public final FleetConfiguration configuration() {
        return this.configuration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final Integer maxWorkerCount() {
        return this.maxWorkerCount;
    }

    public final Integer minWorkerCount() {
        return this.minWorkerCount;
    }

    public final FleetStatus status() {
        return FleetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer targetWorkerCount() {
        return this.targetWorkerCount;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Integer workerCount() {
        return this.workerCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetSummary)) {
            return false;
        }
        FleetSummary other = (FleetSummary)obj;
        return Objects.equals(this.autoScalingStatusAsString(), other.autoScalingStatusAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(this.minWorkerCount(), other.minWorkerCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetWorkerCount(), other.targetWorkerCount()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.workerCount(), other.workerCount());
    }

    public final String toString() {
        return ToString.builder((String)"FleetSummary").add("AutoScalingStatus", (Object)this.autoScalingStatusAsString()).add("Configuration", (Object)this.configuration()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DisplayName", (Object)this.displayName()).add("FarmId", (Object)this.farmId()).add("FleetId", (Object)this.fleetId()).add("MaxWorkerCount", (Object)this.maxWorkerCount()).add("MinWorkerCount", (Object)this.minWorkerCount()).add("Status", (Object)this.statusAsString()).add("TargetWorkerCount", (Object)this.targetWorkerCount()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("WorkerCount", (Object)this.workerCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingStatus": {
                return Optional.ofNullable(clazz.cast(this.autoScalingStatusAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "maxWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.maxWorkerCount()));
            }
            case "minWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.minWorkerCount()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.targetWorkerCount()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "workerCount": {
                return Optional.ofNullable(clazz.cast(this.workerCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetSummary, T> g) {
        return obj -> g.apply((FleetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingStatus;
        private FleetConfiguration configuration;
        private Instant createdAt;
        private String createdBy;
        private String displayName;
        private String farmId;
        private String fleetId;
        private Integer maxWorkerCount;
        private Integer minWorkerCount;
        private String status;
        private Integer targetWorkerCount;
        private Instant updatedAt;
        private String updatedBy;
        private Integer workerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetSummary model) {
            this.autoScalingStatus(model.autoScalingStatus);
            this.configuration(model.configuration);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.displayName(model.displayName);
            this.farmId(model.farmId);
            this.fleetId(model.fleetId);
            this.maxWorkerCount(model.maxWorkerCount);
            this.minWorkerCount(model.minWorkerCount);
            this.status(model.status);
            this.targetWorkerCount(model.targetWorkerCount);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.workerCount(model.workerCount);
        }

        public final String getAutoScalingStatus() {
            return this.autoScalingStatus;
        }

        public final void setAutoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
        }

        @Override
        public final Builder autoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
            return this;
        }

        @Override
        public final Builder autoScalingStatus(AutoScalingStatus autoScalingStatus) {
            this.autoScalingStatus(autoScalingStatus == null ? null : autoScalingStatus.toString());
            return this;
        }

        public final FleetConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FleetConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FleetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return this.minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getTargetWorkerCount() {
            return this.targetWorkerCount;
        }

        public final void setTargetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
        }

        @Override
        public final Builder targetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Integer getWorkerCount() {
            return this.workerCount;
        }

        public final void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        @Override
        public final Builder workerCount(Integer workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public FleetSummary build() {
            return new FleetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetSummary> {
        public Builder autoScalingStatus(String var1);

        public Builder autoScalingStatus(AutoScalingStatus var1);

        public Builder configuration(FleetConfiguration var1);

        default public Builder configuration(Consumer<FleetConfiguration.Builder> configuration) {
            return this.configuration((FleetConfiguration)((FleetConfiguration.Builder)FleetConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder displayName(String var1);

        public Builder farmId(String var1);

        public Builder fleetId(String var1);

        public Builder maxWorkerCount(Integer var1);

        public Builder minWorkerCount(Integer var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder targetWorkerCount(Integer var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder workerCount(Integer var1);
    }
}

