/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersCopier;
import software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetJobEntityRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, BatchGetJobEntityRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(BatchGetJobEntityRequest.getter(BatchGetJobEntityRequest::farmId)).setter(BatchGetJobEntityRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(BatchGetJobEntityRequest.getter(BatchGetJobEntityRequest::fleetId)).setter(BatchGetJobEntityRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()}).build();
    private static final SdkField<List<JobEntityIdentifiersUnion>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identifiers").getter(BatchGetJobEntityRequest.getter(BatchGetJobEntityRequest::identifiers)).setter(BatchGetJobEntityRequest.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobEntityIdentifiersUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerId").getter(BatchGetJobEntityRequest.getter(BatchGetJobEntityRequest::workerId)).setter(BatchGetJobEntityRequest.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_ID_FIELD, IDENTIFIERS_FIELD, WORKER_ID_FIELD));
    private final String farmId;
    private final String fleetId;
    private final List<JobEntityIdentifiersUnion> identifiers;
    private final String workerId;

    private BatchGetJobEntityRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.identifiers = builder.identifiers;
        this.workerId = builder.workerId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final boolean hasIdentifiers() {
        return this.identifiers != null && !(this.identifiers instanceof SdkAutoConstructList);
    }

    public final List<JobEntityIdentifiersUnion> identifiers() {
        return this.identifiers;
    }

    public final String workerId() {
        return this.workerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiers() ? this.identifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobEntityRequest)) {
            return false;
        }
        BatchGetJobEntityRequest other = (BatchGetJobEntityRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.fleetId(), other.fleetId()) && this.hasIdentifiers() == other.hasIdentifiers() && Objects.equals(this.identifiers(), other.identifiers()) && Objects.equals(this.workerId(), other.workerId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetJobEntityRequest").add("FarmId", (Object)this.farmId()).add("FleetId", (Object)this.fleetId()).add("Identifiers", this.hasIdentifiers() ? this.identifiers() : null).add("WorkerId", (Object)this.workerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
            case "workerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobEntityRequest, T> g) {
        return obj -> g.apply((BatchGetJobEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String fleetId;
        private List<JobEntityIdentifiersUnion> identifiers = DefaultSdkAutoConstructList.getInstance();
        private String workerId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobEntityRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.fleetId(model.fleetId);
            this.identifiers(model.identifiers);
            this.workerId(model.workerId);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final List<JobEntityIdentifiersUnion.Builder> getIdentifiers() {
            List<JobEntityIdentifiersUnion.Builder> result = JobEntityIdentifiersCopier.copyToBuilder(this.identifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentifiers(Collection<JobEntityIdentifiersUnion.BuilderImpl> identifiers) {
            this.identifiers = JobEntityIdentifiersCopier.copyFromBuilder(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<JobEntityIdentifiersUnion> identifiers) {
            this.identifiers = JobEntityIdentifiersCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(JobEntityIdentifiersUnion ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<JobEntityIdentifiersUnion.Builder> ... identifiers) {
            this.identifiers(Stream.of(identifiers).map(c -> (JobEntityIdentifiersUnion)((JobEntityIdentifiersUnion.Builder)JobEntityIdentifiersUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetJobEntityRequest build() {
            return new BatchGetJobEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetJobEntityRequest> {
        public Builder farmId(String var1);

        public Builder fleetId(String var1);

        public Builder identifiers(Collection<JobEntityIdentifiersUnion> var1);

        public Builder identifiers(JobEntityIdentifiersUnion ... var1);

        public Builder identifiers(Consumer<JobEntityIdentifiersUnion.Builder> ... var1);

        public Builder workerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

