/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBudgetRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, GetBudgetRequest> {
    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("budgetId").getter(GetBudgetRequest.getter(GetBudgetRequest::budgetId)).setter(GetBudgetRequest.setter(Builder::budgetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("budgetId").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(GetBudgetRequest.getter(GetBudgetRequest::farmId)).setter(GetBudgetRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_ID_FIELD, FARM_ID_FIELD));
    private final String budgetId;
    private final String farmId;

    private GetBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.budgetId = builder.budgetId;
        this.farmId = builder.farmId;
    }

    public final String budgetId() {
        return this.budgetId;
    }

    public final String farmId() {
        return this.farmId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBudgetRequest)) {
            return false;
        }
        GetBudgetRequest other = (GetBudgetRequest)((Object)obj);
        return Objects.equals(this.budgetId(), other.budgetId()) && Objects.equals(this.farmId(), other.farmId());
    }

    public final String toString() {
        return ToString.builder((String)"GetBudgetRequest").add("BudgetId", (Object)this.budgetId()).add("FarmId", (Object)this.farmId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "budgetId": {
                return Optional.ofNullable(clazz.cast(this.budgetId()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBudgetRequest, T> g) {
        return obj -> g.apply((GetBudgetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String budgetId;
        private String farmId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBudgetRequest model) {
            super(model);
            this.budgetId(model.budgetId);
            this.farmId(model.farmId);
        }

        public final String getBudgetId() {
            return this.budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBudgetRequest build() {
            return new GetBudgetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBudgetRequest> {
        public Builder budgetId(String var1);

        public Builder farmId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

