/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.ExceptionContextCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThrottlingException
extends DeadlineException
implements ToCopyableBuilder<Builder, ThrottlingException> {
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("context").getter(ThrottlingException.getter(ThrottlingException::context)).setter(ThrottlingException.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quotaCode").getter(ThrottlingException.getter(ThrottlingException::quotaCode)).setter(ThrottlingException.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quotaCode").build()}).build();
    private static final SdkField<Integer> RETRY_AFTER_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retryAfterSeconds").getter(ThrottlingException.getter(ThrottlingException::retryAfterSeconds)).setter(ThrottlingException.setter(Builder::retryAfterSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Retry-After").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(ThrottlingException.getter(ThrottlingException::serviceCode)).setter(ThrottlingException.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD, QUOTA_CODE_FIELD, RETRY_AFTER_SECONDS_FIELD, SERVICE_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> context;
    private final String quotaCode;
    private final Integer retryAfterSeconds;
    private final String serviceCode;

    private ThrottlingException(BuilderImpl builder) {
        super(builder);
        this.context = builder.context;
        this.quotaCode = builder.quotaCode;
        this.retryAfterSeconds = builder.retryAfterSeconds;
        this.serviceCode = builder.serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String quotaCode() {
        return this.quotaCode;
    }

    public Integer retryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public boolean isRetryableException() {
        return true;
    }

    public boolean isThrottlingException() {
        return true;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThrottlingException, T> g) {
        return obj -> g.apply((ThrottlingException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineException.BuilderImpl
    implements Builder {
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private String quotaCode;
        private Integer retryAfterSeconds;
        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottlingException model) {
            super(model);
            this.context(model.context);
            this.quotaCode(model.quotaCode);
            this.retryAfterSeconds(model.retryAfterSeconds);
            this.serviceCode(model.serviceCode);
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
            return this;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final Integer getRetryAfterSeconds() {
            return this.retryAfterSeconds;
        }

        public final void setRetryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ThrottlingException build() {
            return new ThrottlingException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThrottlingException>,
    DeadlineException.Builder {
        public Builder context(Map<String, String> var1);

        public Builder quotaCode(String var1);

        public Builder retryAfterSeconds(Integer var1);

        public Builder serviceCode(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

