/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldSortExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldSortExpression> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FieldSortExpression.getter(FieldSortExpression::name)).setter(FieldSortExpression.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(FieldSortExpression.getter(FieldSortExpression::sortOrderAsString)).setter(FieldSortExpression.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String sortOrder;

    private FieldSortExpression(BuilderImpl builder) {
        this.name = builder.name;
        this.sortOrder = builder.sortOrder;
    }

    public final String name() {
        return this.name;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSortExpression)) {
            return false;
        }
        FieldSortExpression other = (FieldSortExpression)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FieldSortExpression").add("Name", (Object)this.name()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldSortExpression, T> g) {
        return obj -> g.apply((FieldSortExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSortExpression model) {
            this.name(model.name);
            this.sortOrder(model.sortOrder);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public FieldSortExpression build() {
            return new FieldSortExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldSortExpression> {
        public Builder name(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

