/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.ConflictExceptionReason;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.ExceptionContextCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictException
extends DeadlineException
implements ToCopyableBuilder<Builder, ConflictException> {
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("context").getter(ConflictException.getter(ConflictException::context)).setter(ConflictException.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ConflictException.getter(ConflictException::reasonAsString)).setter(ConflictException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ConflictException.getter(ConflictException::resourceId)).setter(ConflictException.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ConflictException.getter(ConflictException::resourceType)).setter(ConflictException.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD, REASON_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> context;
    private final String reason;
    private final String resourceId;
    private final String resourceType;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.context = builder.context;
        this.reason = builder.reason;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public Map<String, String> context() {
        return this.context;
    }

    public ConflictExceptionReason reason() {
        return ConflictExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineException.BuilderImpl
    implements Builder {
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private String reason;
        private String resourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            this.context(model.context);
            this.reason(model.reason);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ConflictExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictException>,
    DeadlineException.Builder {
        public Builder context(Map<String, String> var1);

        public Builder reason(String var1);

        public Builder reason(ConflictExceptionReason var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

