/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo;
import software.amazon.awssdk.services.deadline.model.UpdatedSessionActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkerScheduleRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateWorkerScheduleRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateWorkerScheduleRequest.getter(UpdateWorkerScheduleRequest::farmId)).setter(UpdateWorkerScheduleRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(UpdateWorkerScheduleRequest.getter(UpdateWorkerScheduleRequest::fleetId)).setter(UpdateWorkerScheduleRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()}).build();
    private static final SdkField<Map<String, UpdatedSessionActionInfo>> UPDATED_SESSION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("updatedSessionActions").getter(UpdateWorkerScheduleRequest.getter(UpdateWorkerScheduleRequest::updatedSessionActions)).setter(UpdateWorkerScheduleRequest.setter(Builder::updatedSessionActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedSessionActions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdatedSessionActionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerId").getter(UpdateWorkerScheduleRequest.getter(UpdateWorkerScheduleRequest::workerId)).setter(UpdateWorkerScheduleRequest.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_ID_FIELD, UPDATED_SESSION_ACTIONS_FIELD, WORKER_ID_FIELD));
    private final String farmId;
    private final String fleetId;
    private final Map<String, UpdatedSessionActionInfo> updatedSessionActions;
    private final String workerId;

    private UpdateWorkerScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.updatedSessionActions = builder.updatedSessionActions;
        this.workerId = builder.workerId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final boolean hasUpdatedSessionActions() {
        return this.updatedSessionActions != null && !(this.updatedSessionActions instanceof SdkAutoConstructMap);
    }

    public final Map<String, UpdatedSessionActionInfo> updatedSessionActions() {
        return this.updatedSessionActions;
    }

    public final String workerId() {
        return this.workerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdatedSessionActions() ? this.updatedSessionActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerScheduleRequest)) {
            return false;
        }
        UpdateWorkerScheduleRequest other = (UpdateWorkerScheduleRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.fleetId(), other.fleetId()) && this.hasUpdatedSessionActions() == other.hasUpdatedSessionActions() && Objects.equals(this.updatedSessionActions(), other.updatedSessionActions()) && Objects.equals(this.workerId(), other.workerId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkerScheduleRequest").add("FarmId", (Object)this.farmId()).add("FleetId", (Object)this.fleetId()).add("UpdatedSessionActions", this.hasUpdatedSessionActions() ? this.updatedSessionActions() : null).add("WorkerId", (Object)this.workerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "updatedSessionActions": {
                return Optional.ofNullable(clazz.cast(this.updatedSessionActions()));
            }
            case "workerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerScheduleRequest, T> g) {
        return obj -> g.apply((UpdateWorkerScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String fleetId;
        private Map<String, UpdatedSessionActionInfo> updatedSessionActions = DefaultSdkAutoConstructMap.getInstance();
        private String workerId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerScheduleRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.fleetId(model.fleetId);
            this.updatedSessionActions(model.updatedSessionActions);
            this.workerId(model.workerId);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Map<String, UpdatedSessionActionInfo.Builder> getUpdatedSessionActions() {
            Map<String, UpdatedSessionActionInfo.Builder> result = UpdatedSessionActionsCopier.copyToBuilder(this.updatedSessionActions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUpdatedSessionActions(Map<String, UpdatedSessionActionInfo.BuilderImpl> updatedSessionActions) {
            this.updatedSessionActions = UpdatedSessionActionsCopier.copyFromBuilder(updatedSessionActions);
        }

        @Override
        public final Builder updatedSessionActions(Map<String, UpdatedSessionActionInfo> updatedSessionActions) {
            this.updatedSessionActions = UpdatedSessionActionsCopier.copy(updatedSessionActions);
            return this;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkerScheduleRequest build() {
            return new UpdateWorkerScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkerScheduleRequest> {
        public Builder farmId(String var1);

        public Builder fleetId(String var1);

        public Builder updatedSessionActions(Map<String, UpdatedSessionActionInfo> var1);

        public Builder workerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

