/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.SessionActionSummary;

public class ListSessionActionsPublisher
implements SdkPublisher<ListSessionActionsResponse> {
    private final DeadlineAsyncClient client;
    private final ListSessionActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionActionsPublisher(DeadlineAsyncClient client, ListSessionActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionActionsPublisher(DeadlineAsyncClient client, ListSessionActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SessionActionSummary> sessionActions() {
        Function<ListSessionActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionActions() != null) {
                return response.sessionActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSessionActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSessionActionsResponseFetcher
    implements AsyncPageFetcher<ListSessionActionsResponse> {
        private ListSessionActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionActionsResponse> nextPage(ListSessionActionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionActionsPublisher.this.client.listSessionActions(ListSessionActionsPublisher.this.firstRequest);
            }
            return ListSessionActionsPublisher.this.client.listSessionActions((ListSessionActionsRequest)((Object)ListSessionActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

