/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueueBlockedReason {
    NO_BUDGET_CONFIGURED("NO_BUDGET_CONFIGURED"),
    BUDGET_THRESHOLD_REACHED("BUDGET_THRESHOLD_REACHED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueueBlockedReason> VALUE_MAP;
    private final String value;

    private QueueBlockedReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueueBlockedReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueueBlockedReason> knownValues() {
        EnumSet<QueueBlockedReason> knownValues = EnumSet.allOf(QueueBlockedReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueueBlockedReason.class, QueueBlockedReason::toString);
    }
}

