/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentDetailsEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentDetailsEntity> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(EnvironmentDetailsEntity.getter(EnvironmentDetailsEntity::environmentId)).setter(EnvironmentDetailsEntity.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(EnvironmentDetailsEntity.getter(EnvironmentDetailsEntity::jobId)).setter(EnvironmentDetailsEntity.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(EnvironmentDetailsEntity.getter(EnvironmentDetailsEntity::schemaVersion)).setter(EnvironmentDetailsEntity.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<Document> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("template").getter(EnvironmentDetailsEntity.getter(EnvironmentDetailsEntity::template)).setter(EnvironmentDetailsEntity.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, JOB_ID_FIELD, SCHEMA_VERSION_FIELD, TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String environmentId;
    private final String jobId;
    private final String schemaVersion;
    private final Document template;

    private EnvironmentDetailsEntity(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.jobId = builder.jobId;
        this.schemaVersion = builder.schemaVersion;
        this.template = builder.template;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final Document template() {
        return this.template;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentDetailsEntity)) {
            return false;
        }
        EnvironmentDetailsEntity other = (EnvironmentDetailsEntity)obj;
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.template(), other.template());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentDetailsEntity").add("EnvironmentId", (Object)this.environmentId()).add("JobId", (Object)this.jobId()).add("SchemaVersion", (Object)this.schemaVersion()).add("Template", (Object)(this.template() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentDetailsEntity, T> g) {
        return obj -> g.apply((EnvironmentDetailsEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String jobId;
        private String schemaVersion;
        private Document template;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentDetailsEntity model) {
            this.environmentId(model.environmentId);
            this.jobId(model.jobId);
            this.schemaVersion(model.schemaVersion);
            this.template(model.template);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Document getTemplate() {
            return this.template;
        }

        public final void setTemplate(Document template) {
            this.template = template;
        }

        @Override
        public final Builder template(Document template) {
            this.template = template;
            return this;
        }

        public EnvironmentDetailsEntity build() {
            return new EnvironmentDetailsEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentDetailsEntity> {
        public Builder environmentId(String var1);

        public Builder jobId(String var1);

        public Builder schemaVersion(String var1);

        public Builder template(Document var1);
    }
}

