/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.TaskParameterValue;
import software.amazon.awssdk.services.deadline.model.TaskParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignedTaskRunSessionActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssignedTaskRunSessionActionDefinition> {
    private static final SdkField<Map<String, TaskParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(AssignedTaskRunSessionActionDefinition.getter(AssignedTaskRunSessionActionDefinition::parameters)).setter(AssignedTaskRunSessionActionDefinition.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(AssignedTaskRunSessionActionDefinition.getter(AssignedTaskRunSessionActionDefinition::stepId)).setter(AssignedTaskRunSessionActionDefinition.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(AssignedTaskRunSessionActionDefinition.getter(AssignedTaskRunSessionActionDefinition::taskId)).setter(AssignedTaskRunSessionActionDefinition.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, STEP_ID_FIELD, TASK_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, TaskParameterValue> parameters;
    private final String stepId;
    private final String taskId;

    private AssignedTaskRunSessionActionDefinition(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.stepId = builder.stepId;
        this.taskId = builder.taskId;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, TaskParameterValue> parameters() {
        return this.parameters;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedTaskRunSessionActionDefinition)) {
            return false;
        }
        AssignedTaskRunSessionActionDefinition other = (AssignedTaskRunSessionActionDefinition)obj;
        return this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"AssignedTaskRunSessionActionDefinition").add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("StepId", (Object)this.stepId()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignedTaskRunSessionActionDefinition, T> g) {
        return obj -> g.apply((AssignedTaskRunSessionActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, TaskParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String stepId;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignedTaskRunSessionActionDefinition model) {
            this.parameters(model.parameters);
            this.stepId(model.stepId);
            this.taskId(model.taskId);
        }

        public final Map<String, TaskParameterValue.Builder> getParameters() {
            Map<String, TaskParameterValue.Builder> result = TaskParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TaskParameterValue.BuilderImpl> parameters) {
            this.parameters = TaskParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TaskParameterValue> parameters) {
            this.parameters = TaskParametersCopier.copy(parameters);
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public AssignedTaskRunSessionActionDefinition build() {
            return new AssignedTaskRunSessionActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssignedTaskRunSessionActionDefinition> {
        public Builder parameters(Map<String, TaskParameterValue> var1);

        public Builder stepId(String var1);

        public Builder taskId(String var1);
    }
}

