/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.Attachments;
import software.amazon.awssdk.services.deadline.model.CreateJobTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.JobParameter;
import software.amazon.awssdk.services.deadline.model.JobParametersCopier;
import software.amazon.awssdk.services.deadline.model.JobTemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<Attachments> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attachments").getter(CreateJobRequest.getter(CreateJobRequest::attachments)).setter(CreateJobRequest.setter(Builder::attachments)).constructor(Attachments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateJobRequest.getter(CreateJobRequest::clientToken)).setter(CreateJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(CreateJobRequest.getter(CreateJobRequest::farmId)).setter(CreateJobRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailedTasksCount").getter(CreateJobRequest.getter(CreateJobRequest::maxFailedTasksCount)).setter(CreateJobRequest.setter(Builder::maxFailedTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRetriesPerTask").getter(CreateJobRequest.getter(CreateJobRequest::maxRetriesPerTask)).setter(CreateJobRequest.setter(Builder::maxRetriesPerTask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()}).build();
    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(CreateJobRequest.getter(CreateJobRequest::parameters)).setter(CreateJobRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(CreateJobRequest.getter(CreateJobRequest::priority)).setter(CreateJobRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(CreateJobRequest.getter(CreateJobRequest::queueId)).setter(CreateJobRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageProfileId").getter(CreateJobRequest.getter(CreateJobRequest::storageProfileId)).setter(CreateJobRequest.setter(Builder::storageProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(CreateJobRequest.getter(CreateJobRequest::targetTaskRunStatusAsString)).setter(CreateJobRequest.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(CreateJobRequest.getter(CreateJobRequest::template)).setter(CreateJobRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(CreateJobRequest.getter(CreateJobRequest::templateTypeAsString)).setter(CreateJobRequest.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, CLIENT_TOKEN_FIELD, FARM_ID_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, PARAMETERS_FIELD, PRIORITY_FIELD, QUEUE_ID_FIELD, STORAGE_PROFILE_ID_FIELD, TARGET_TASK_RUN_STATUS_FIELD, TEMPLATE_FIELD, TEMPLATE_TYPE_FIELD));
    private final Attachments attachments;
    private final String clientToken;
    private final String farmId;
    private final Integer maxFailedTasksCount;
    private final Integer maxRetriesPerTask;
    private final Map<String, JobParameter> parameters;
    private final Integer priority;
    private final String queueId;
    private final String storageProfileId;
    private final String targetTaskRunStatus;
    private final String template;
    private final String templateType;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.attachments = builder.attachments;
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.parameters = builder.parameters;
        this.priority = builder.priority;
        this.queueId = builder.queueId;
        this.storageProfileId = builder.storageProfileId;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.template = builder.template;
        this.templateType = builder.templateType;
    }

    public final Attachments attachments() {
        return this.attachments;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final Integer maxFailedTasksCount() {
        return this.maxFailedTasksCount;
    }

    public final Integer maxRetriesPerTask() {
        return this.maxRetriesPerTask;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, JobParameter> parameters() {
        return this.parameters;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String storageProfileId() {
        return this.storageProfileId;
    }

    public final CreateJobTargetTaskRunStatus targetTaskRunStatus() {
        return CreateJobTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final String template() {
        return this.template;
    }

    public final JobTemplateType templateType() {
        return JobTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.maxFailedTasksCount(), other.maxFailedTasksCount()) && Objects.equals(this.maxRetriesPerTask(), other.maxRetriesPerTask()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.storageProfileId(), other.storageProfileId()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("Attachments", (Object)this.attachments()).add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("MaxFailedTasksCount", (Object)this.maxFailedTasksCount()).add("MaxRetriesPerTask", (Object)this.maxRetriesPerTask()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Priority", (Object)this.priority()).add("QueueId", (Object)this.queueId()).add("StorageProfileId", (Object)this.storageProfileId()).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("Template", (Object)(this.template() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "maxFailedTasksCount": {
                return Optional.ofNullable(clazz.cast(this.maxFailedTasksCount()));
            }
            case "maxRetriesPerTask": {
                return Optional.ofNullable(clazz.cast(this.maxRetriesPerTask()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "storageProfileId": {
                return Optional.ofNullable(clazz.cast(this.storageProfileId()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private Attachments attachments;
        private String clientToken;
        private String farmId;
        private Integer maxFailedTasksCount;
        private Integer maxRetriesPerTask;
        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer priority;
        private String queueId;
        private String storageProfileId;
        private String targetTaskRunStatus;
        private String template;
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.attachments(model.attachments);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.maxFailedTasksCount(model.maxFailedTasksCount);
            this.maxRetriesPerTask(model.maxRetriesPerTask);
            this.parameters(model.parameters);
            this.priority(model.priority);
            this.queueId(model.queueId);
            this.storageProfileId(model.storageProfileId);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.template(model.template);
            this.templateType(model.templateType);
        }

        public final Attachments.Builder getAttachments() {
            return this.attachments != null ? this.attachments.toBuilder() : null;
        }

        public final void setAttachments(Attachments.BuilderImpl attachments) {
            this.attachments = attachments != null ? attachments.build() : null;
        }

        @Override
        public final Builder attachments(Attachments attachments) {
            this.attachments = attachments;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return this.maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return this.maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getStorageProfileId() {
            return this.storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(CreateJobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final String getTemplate() {
            return this.template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(JobTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder attachments(Attachments var1);

        default public Builder attachments(Consumer<Attachments.Builder> attachments) {
            return this.attachments((Attachments)((Attachments.Builder)Attachments.builder().applyMutation(attachments)).build());
        }

        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder maxFailedTasksCount(Integer var1);

        public Builder maxRetriesPerTask(Integer var1);

        public Builder parameters(Map<String, JobParameter> var1);

        public Builder priority(Integer var1);

        public Builder queueId(String var1);

        public Builder storageProfileId(String var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(CreateJobTargetTaskRunStatus var1);

        public Builder template(String var1);

        public Builder templateType(String var1);

        public Builder templateType(JobTemplateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

