/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FleetMember;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;

public class ListFleetMembersPublisher
implements SdkPublisher<ListFleetMembersResponse> {
    private final DeadlineAsyncClient client;
    private final ListFleetMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetMembersPublisher(DeadlineAsyncClient client, ListFleetMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetMembersPublisher(DeadlineAsyncClient client, ListFleetMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetMember> members() {
        Function<ListFleetMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFleetMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFleetMembersResponseFetcher
    implements AsyncPageFetcher<ListFleetMembersResponse> {
        private ListFleetMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetMembersResponse> nextPage(ListFleetMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFleetMembersPublisher.this.client.listFleetMembers(ListFleetMembersPublisher.this.firstRequest);
            }
            return ListFleetMembersPublisher.this.client.listFleetMembers((ListFleetMembersRequest)((Object)ListFleetMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

