/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.EnvironmentTemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQueueEnvironmentRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateQueueEnvironmentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::clientToken)).setter(UpdateQueueEnvironmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::farmId)).setter(UpdateQueueEnvironmentRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::priority)).setter(UpdateQueueEnvironmentRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueEnvironmentId").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::queueEnvironmentId)).setter(UpdateQueueEnvironmentRequest.setter(Builder::queueEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueEnvironmentId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::queueId)).setter(UpdateQueueEnvironmentRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::template)).setter(UpdateQueueEnvironmentRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(UpdateQueueEnvironmentRequest.getter(UpdateQueueEnvironmentRequest::templateTypeAsString)).setter(UpdateQueueEnvironmentRequest.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, FARM_ID_FIELD, PRIORITY_FIELD, QUEUE_ENVIRONMENT_ID_FIELD, QUEUE_ID_FIELD, TEMPLATE_FIELD, TEMPLATE_TYPE_FIELD));
    private final String clientToken;
    private final String farmId;
    private final Integer priority;
    private final String queueEnvironmentId;
    private final String queueId;
    private final String template;
    private final String templateType;

    private UpdateQueueEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.priority = builder.priority;
        this.queueEnvironmentId = builder.queueEnvironmentId;
        this.queueId = builder.queueId;
        this.template = builder.template;
        this.templateType = builder.templateType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String queueEnvironmentId() {
        return this.queueEnvironmentId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String template() {
        return this.template;
    }

    public final EnvironmentTemplateType templateType() {
        return EnvironmentTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueEnvironmentRequest)) {
            return false;
        }
        UpdateQueueEnvironmentRequest other = (UpdateQueueEnvironmentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queueEnvironmentId(), other.queueEnvironmentId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQueueEnvironmentRequest").add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("Priority", (Object)this.priority()).add("QueueEnvironmentId", (Object)this.queueEnvironmentId()).add("QueueId", (Object)this.queueId()).add("Template", (Object)(this.template() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "queueEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.queueEnvironmentId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateQueueEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String farmId;
        private Integer priority;
        private String queueEnvironmentId;
        private String queueId;
        private String template;
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueEnvironmentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.priority(model.priority);
            this.queueEnvironmentId(model.queueEnvironmentId);
            this.queueId(model.queueId);
            this.template(model.template);
            this.templateType(model.templateType);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueueEnvironmentId() {
            return this.queueEnvironmentId;
        }

        public final void setQueueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
        }

        @Override
        public final Builder queueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getTemplate() {
            return this.template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(EnvironmentTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueEnvironmentRequest build() {
            return new UpdateQueueEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQueueEnvironmentRequest> {
        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder priority(Integer var1);

        public Builder queueEnvironmentId(String var1);

        public Builder queueId(String var1);

        public Builder template(String var1);

        public Builder templateType(String var1);

        public Builder templateType(EnvironmentTemplateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

