/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dax.model.DaxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSubnetGroupResponse
extends DaxResponse
implements ToCopyableBuilder<Builder, DeleteSubnetGroupResponse> {
    private static final SdkField<String> DELETION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteSubnetGroupResponse.getter(DeleteSubnetGroupResponse::deletionMessage)).setter(DeleteSubnetGroupResponse.setter(Builder::deletionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_MESSAGE_FIELD));
    private final String deletionMessage;

    private DeleteSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.deletionMessage = builder.deletionMessage;
    }

    public String deletionMessage() {
        return this.deletionMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubnetGroupResponse)) {
            return false;
        }
        DeleteSubnetGroupResponse other = (DeleteSubnetGroupResponse)((Object)obj);
        return Objects.equals(this.deletionMessage(), other.deletionMessage());
    }

    public String toString() {
        return ToString.builder((String)"DeleteSubnetGroupResponse").add("DeletionMessage", (Object)this.deletionMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletionMessage": {
                return Optional.ofNullable(clazz.cast(this.deletionMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubnetGroupResponse, T> g) {
        return obj -> g.apply((DeleteSubnetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DaxResponse.BuilderImpl
    implements Builder {
        private String deletionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubnetGroupResponse model) {
            super(model);
            this.deletionMessage(model.deletionMessage);
        }

        public final String getDeletionMessage() {
            return this.deletionMessage;
        }

        @Override
        public final Builder deletionMessage(String deletionMessage) {
            this.deletionMessage = deletionMessage;
            return this;
        }

        public final void setDeletionMessage(String deletionMessage) {
            this.deletionMessage = deletionMessage;
        }

        @Override
        public DeleteSubnetGroupResponse build() {
            return new DeleteSubnetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DaxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSubnetGroupResponse> {
        public Builder deletionMessage(String var1);
    }
}

