/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dax.DaxClient;
import software.amazon.awssdk.services.dax.DaxClientBuilder;
import software.amazon.awssdk.services.dax.DaxServiceClientConfiguration;
import software.amazon.awssdk.services.dax.DefaultDaxBaseClientBuilder;
import software.amazon.awssdk.services.dax.DefaultDaxClient;
import software.amazon.awssdk.services.dax.endpoints.DaxEndpointProvider;

@SdkInternalApi
final class DefaultDaxClientBuilder
extends DefaultDaxBaseClientBuilder<DaxClientBuilder, DaxClient>
implements DaxClientBuilder {
    DefaultDaxClientBuilder() {
    }

    @Override
    public DefaultDaxClientBuilder endpointProvider(DaxEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DaxClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDaxClientBuilder.validateClientOptions(clientConfiguration);
        DaxServiceClientConfiguration serviceClientConfiguration = DaxServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDaxClient(serviceClientConfiguration, clientConfiguration);
    }
}

