/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubnetGroupsResponse extends DaxResponse implements
        ToCopyableBuilder<DescribeSubnetGroupsResponse.Builder, DescribeSubnetGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSubnetGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SubnetGroup>> SUBNET_GROUPS_FIELD = SdkField
            .<List<SubnetGroup>> builder(MarshallingType.LIST)
            .memberName("SubnetGroups")
            .getter(getter(DescribeSubnetGroupsResponse::subnetGroups))
            .setter(setter(Builder::subnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUBNET_GROUPS_FIELD));

    private final String nextToken;

    private final List<SubnetGroup> subnetGroups;

    private DescribeSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subnetGroups = builder.subnetGroups;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the SubnetGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetGroups() {
        return subnetGroups != null && !(subnetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of subnet groups. Each element in the array represents a single subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of subnet groups. Each element in the array represents a single subnet group.
     */
    public final List<SubnetGroup> subnetGroups() {
        return subnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetGroups() ? subnetGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsResponse)) {
            return false;
        }
        DescribeSubnetGroupsResponse other = (DescribeSubnetGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSubnetGroups() == other.hasSubnetGroups()
                && Objects.equals(subnetGroups(), other.subnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSubnetGroupsResponse").add("NextToken", nextToken())
                .add("SubnetGroups", hasSubnetGroups() ? subnetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SubnetGroups":
            return Optional.ofNullable(clazz.cast(subnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param nextToken
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of subnet groups. Each element in the array represents a single subnet group.
         * </p>
         * 
         * @param subnetGroups
         *        An array of subnet groups. Each element in the array represents a single subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroups(Collection<SubnetGroup> subnetGroups);

        /**
         * <p>
         * An array of subnet groups. Each element in the array represents a single subnet group.
         * </p>
         * 
         * @param subnetGroups
         *        An array of subnet groups. Each element in the array represents a single subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroups(SubnetGroup... subnetGroups);

        /**
         * <p>
         * An array of subnet groups. Each element in the array represents a single subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubnetGroup>.Builder} avoiding the need to
         * create one manually via {@link List<SubnetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubnetGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #subnetGroups(List<SubnetGroup>)}.
         * 
         * @param subnetGroups
         *        a consumer that will call methods on {@link List<SubnetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetGroups(List<SubnetGroup>)
         */
        Builder subnetGroups(Consumer<SubnetGroup.Builder>... subnetGroups);
    }

    static final class BuilderImpl extends DaxResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SubnetGroup> subnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            subnetGroups(model.subnetGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SubnetGroup.Builder> getSubnetGroups() {
            if (subnetGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetGroups != null ? subnetGroups.stream().map(SubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetGroups(Collection<SubnetGroup> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copy(subnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(SubnetGroup... subnetGroups) {
            subnetGroups(Arrays.asList(subnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(Consumer<SubnetGroup.Builder>... subnetGroups) {
            subnetGroups(Stream.of(subnetGroups).map(c -> SubnetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubnetGroups(Collection<SubnetGroup.BuilderImpl> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copyFromBuilder(subnetGroups);
        }

        @Override
        public DescribeSubnetGroupsResponse build() {
            return new DescribeSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
