/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubnetGroupRequest extends DaxRequest implements
        ToCopyableBuilder<CreateSubnetGroupRequest.Builder, CreateSubnetGroupRequest> {
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(CreateSubnetGroupRequest::subnetGroupName))
            .setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSubnetGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateSubnetGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_GROUP_NAME_FIELD,
            DESCRIPTION_FIELD, SUBNET_IDS_FIELD));

    private final String subnetGroupName;

    private final String description;

    private final List<String> subnetIds;

    private CreateSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * A name for the subnet group. This value is stored as a lowercase string.
     * </p>
     * 
     * @return A name for the subnet group. This value is stored as a lowercase string.
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * <p>
     * A description for the subnet group
     * </p>
     * 
     * @return A description for the subnet group
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs for the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC subnet IDs for the subnet group.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetGroupRequest)) {
            return false;
        }
        CreateSubnetGroupRequest other = (CreateSubnetGroupRequest) obj;
        return Objects.equals(subnetGroupName(), other.subnetGroupName()) && Objects.equals(description(), other.description())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubnetGroupRequest").add("SubnetGroupName", subnetGroupName())
                .add("Description", description()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetGroupRequest, T> g) {
        return obj -> g.apply((CreateSubnetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubnetGroupRequest> {
        /**
         * <p>
         * A name for the subnet group. This value is stored as a lowercase string.
         * </p>
         * 
         * @param subnetGroupName
         *        A name for the subnet group. This value is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * A description for the subnet group
         * </p>
         * 
         * @param description
         *        A description for the subnet group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of VPC subnet IDs for the subnet group.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs for the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs for the subnet group.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs for the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String subnetGroupName;

        private String description;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetGroupRequest model) {
            super(model);
            subnetGroupName(model.subnetGroupName);
            description(model.description);
            subnetIds(model.subnetIds);
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetGroupRequest build() {
            return new CreateSubnetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
