/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.DaxResponse;
import software.amazon.awssdk.services.dax.model.SubnetGroup;
import software.amazon.awssdk.services.dax.model.SubnetGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubnetGroupsResponse
extends DaxResponse
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSubnetGroupsResponse.getter(DescribeSubnetGroupsResponse::nextToken)).setter(DescribeSubnetGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SubnetGroup>> SUBNET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetGroups").getter(DescribeSubnetGroupsResponse.getter(DescribeSubnetGroupsResponse::subnetGroups)).setter(DescribeSubnetGroupsResponse.setter(Builder::subnetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SUBNET_GROUPS_FIELD));
    private final String nextToken;
    private final List<SubnetGroup> subnetGroups;

    private DescribeSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subnetGroups = builder.subnetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSubnetGroups() {
        return this.subnetGroups != null && !(this.subnetGroups instanceof SdkAutoConstructList);
    }

    public List<SubnetGroup> subnetGroups() {
        return this.subnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsResponse)) {
            return false;
        }
        DescribeSubnetGroupsResponse other = (DescribeSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.subnetGroups(), other.subnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSubnetGroupsResponse").add("NextToken", (Object)this.nextToken()).add("SubnetGroups", this.subnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.subnetGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeSubnetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DaxResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SubnetGroup> subnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.subnetGroups(model.subnetGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SubnetGroup.Builder> getSubnetGroups() {
            return this.subnetGroups != null ? (Collection)this.subnetGroups.stream().map(SubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetGroups(Collection<SubnetGroup> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copy(subnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(SubnetGroup ... subnetGroups) {
            this.subnetGroups(Arrays.asList(subnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(Consumer<SubnetGroup.Builder> ... subnetGroups) {
            this.subnetGroups(Stream.of(subnetGroups).map(c -> (SubnetGroup)((SubnetGroup.Builder)SubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnetGroups(Collection<SubnetGroup.BuilderImpl> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copyFromBuilder(subnetGroups);
        }

        @Override
        public DescribeSubnetGroupsResponse build() {
            return new DescribeSubnetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DaxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder subnetGroups(Collection<SubnetGroup> var1);

        public Builder subnetGroups(SubnetGroup ... var1);

        public Builder subnetGroups(Consumer<SubnetGroup.Builder> ... var1);
    }
}

