/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.dax.model.DaxRequest;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecreaseReplicationFactorRequest
extends DaxRequest
implements ToCopyableBuilder<Builder, DecreaseReplicationFactorRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(DecreaseReplicationFactorRequest.getter(DecreaseReplicationFactorRequest::clusterName)).setter(DecreaseReplicationFactorRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<Integer> NEW_REPLICATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NewReplicationFactor").getter(DecreaseReplicationFactorRequest.getter(DecreaseReplicationFactorRequest::newReplicationFactor)).setter(DecreaseReplicationFactorRequest.setter(Builder::newReplicationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicationFactor").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(DecreaseReplicationFactorRequest.getter(DecreaseReplicationFactorRequest::availabilityZones)).setter(DecreaseReplicationFactorRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NODE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeIdsToRemove").getter(DecreaseReplicationFactorRequest.getter(DecreaseReplicationFactorRequest::nodeIdsToRemove)).setter(DecreaseReplicationFactorRequest.setter(Builder::nodeIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NEW_REPLICATION_FACTOR_FIELD, AVAILABILITY_ZONES_FIELD, NODE_IDS_TO_REMOVE_FIELD));
    private final String clusterName;
    private final Integer newReplicationFactor;
    private final List<String> availabilityZones;
    private final List<String> nodeIdsToRemove;

    private DecreaseReplicationFactorRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Integer newReplicationFactor() {
        return this.newReplicationFactor;
    }

    public boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public boolean hasNodeIdsToRemove() {
        return this.nodeIdsToRemove != null && !(this.nodeIdsToRemove instanceof SdkAutoConstructList);
    }

    public List<String> nodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newReplicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeIdsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseReplicationFactorRequest)) {
            return false;
        }
        DecreaseReplicationFactorRequest other = (DecreaseReplicationFactorRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.newReplicationFactor(), other.newReplicationFactor()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.nodeIdsToRemove(), other.nodeIdsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"DecreaseReplicationFactorRequest").add("ClusterName", (Object)this.clusterName()).add("NewReplicationFactor", (Object)this.newReplicationFactor()).add("AvailabilityZones", this.availabilityZones()).add("NodeIdsToRemove", this.nodeIdsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "NewReplicationFactor": {
                return Optional.ofNullable(clazz.cast(this.newReplicationFactor()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "NodeIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.nodeIdsToRemove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecreaseReplicationFactorRequest, T> g) {
        return obj -> g.apply((DecreaseReplicationFactorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DaxRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private Integer newReplicationFactor;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> nodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseReplicationFactorRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.newReplicationFactor(model.newReplicationFactor);
            this.availabilityZones(model.availabilityZones);
            this.nodeIdsToRemove(model.nodeIdsToRemove);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return this.newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        public final Collection<String> getNodeIdsToRemove() {
            return this.nodeIdsToRemove;
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseReplicationFactorRequest build() {
            return new DecreaseReplicationFactorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DaxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DecreaseReplicationFactorRequest> {
        public Builder clusterName(String var1);

        public Builder newReplicationFactor(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder nodeIdsToRemove(Collection<String> var1);

        public Builder nodeIdsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

