/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterGroupStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterGroupStatus> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterGroupStatus.getter(ParameterGroupStatus::parameterGroupName)).setter(ParameterGroupStatus.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterGroupStatus.getter(ParameterGroupStatus::parameterApplyStatus)).setter(ParameterGroupStatus.setter(Builder::parameterApplyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build()}).build();
    private static final SdkField<List<String>> NODE_IDS_TO_REBOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ParameterGroupStatus.getter(ParameterGroupStatus::nodeIdsToReboot)).setter(ParameterGroupStatus.setter(Builder::nodeIdsToReboot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToReboot").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD, PARAMETER_APPLY_STATUS_FIELD, NODE_IDS_TO_REBOOT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterGroupName;
    private final String parameterApplyStatus;
    private final List<String> nodeIdsToReboot;

    private ParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.nodeIdsToReboot = builder.nodeIdsToReboot;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public List<String> nodeIdsToReboot() {
        return this.nodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeIdsToReboot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterGroupStatus)) {
            return false;
        }
        ParameterGroupStatus other = (ParameterGroupStatus)obj;
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterApplyStatus(), other.parameterApplyStatus()) && Objects.equals(this.nodeIdsToReboot(), other.nodeIdsToReboot());
    }

    public String toString() {
        return ToString.builder((String)"ParameterGroupStatus").add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterApplyStatus", (Object)this.parameterApplyStatus()).add("NodeIdsToReboot", this.nodeIdsToReboot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterApplyStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterApplyStatus()));
            }
            case "NodeIdsToReboot": {
                return Optional.ofNullable(clazz.cast(this.nodeIdsToReboot()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterGroupStatus, T> g) {
        return obj -> g.apply((ParameterGroupStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterApplyStatus;
        private List<String> nodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterGroupStatus model) {
            this.parameterGroupName(model.parameterGroupName);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.nodeIdsToReboot(model.nodeIdsToReboot);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getNodeIdsToReboot() {
            return this.nodeIdsToReboot;
        }

        @Override
        public final Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToReboot(String ... nodeIdsToReboot) {
            this.nodeIdsToReboot(Arrays.asList(nodeIdsToReboot));
            return this;
        }

        public final void setNodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
        }

        public ParameterGroupStatus build() {
            return new ParameterGroupStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterGroupStatus> {
        public Builder parameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder nodeIdsToReboot(Collection<String> var1);

        public Builder nodeIdsToReboot(String ... var1);
    }
}

