/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RebootNodeRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, RebootNodeRequest> {
    private final String clusterName;
    private final String nodeId;

    private RebootNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeId = builder.nodeId;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String nodeId() {
        return this.nodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootNodeRequest)) {
            return false;
        }
        RebootNodeRequest other = (RebootNodeRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodeId(), other.nodeId());
    }

    public String toString() {
        return ToString.builder((String)"RebootNodeRequest").add("ClusterName", (Object)this.clusterName()).add("NodeId", (Object)this.nodeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.of(clazz.cast(this.clusterName()));
            }
            case "NodeId": {
                return Optional.of(clazz.cast(this.nodeId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootNodeRequest model) {
            this.clusterName(model.clusterName);
            this.nodeId(model.nodeId);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RebootNodeRequest build() {
            return new RebootNodeRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, RebootNodeRequest> {
        public Builder clusterName(String var1);

        public Builder nodeId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

