/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.services.dax.model.ParameterGroupNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParameterGroupsRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, DescribeParameterGroupsRequest> {
    private final List<String> parameterGroupNames;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeParameterGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupNames = builder.parameterGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> parameterGroupNames() {
        return this.parameterGroupNames;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsRequest)) {
            return false;
        }
        DescribeParameterGroupsRequest other = (DescribeParameterGroupsRequest)((Object)obj);
        return Objects.equals(this.parameterGroupNames(), other.parameterGroupNames()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeParameterGroupsRequest").add("ParameterGroupNames", this.parameterGroupNames()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupNames": {
                return Optional.of(clazz.cast(this.parameterGroupNames()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private List<String> parameterGroupNames;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsRequest model) {
            this.parameterGroupNames(model.parameterGroupNames);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getParameterGroupNames() {
            return this.parameterGroupNames;
        }

        @Override
        public final Builder parameterGroupNames(Collection<String> parameterGroupNames) {
            this.parameterGroupNames = ParameterGroupNameListCopier.copy(parameterGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroupNames(String ... parameterGroupNames) {
            this.parameterGroupNames(Arrays.asList(parameterGroupNames));
            return this;
        }

        public final void setParameterGroupNames(Collection<String> parameterGroupNames) {
            this.parameterGroupNames = ParameterGroupNameListCopier.copy(parameterGroupNames);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeParameterGroupsRequest build() {
            return new DescribeParameterGroupsRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, DescribeParameterGroupsRequest> {
        public Builder parameterGroupNames(Collection<String> var1);

        public Builder parameterGroupNames(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

