/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembership;

@SdkInternalApi
public class SecurityGroupMembershipMarshaller {
    private static final MarshallingInfo<String> SECURITYGROUPIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIdentifier").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final SecurityGroupMembershipMarshaller INSTANCE = new SecurityGroupMembershipMarshaller();

    public static SecurityGroupMembershipMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityGroupMembership securityGroupMembership, ProtocolMarshaller protocolMarshaller) {
        if (securityGroupMembership == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)securityGroupMembership.securityGroupIdentifier(), SECURITYGROUPIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)securityGroupMembership.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

