/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.transform.ParameterNameValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterNameValue
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterNameValue> {
    private final String parameterName;
    private final String parameterValue;

    private ParameterNameValue(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterNameValue)) {
            return false;
        }
        ParameterNameValue other = (ParameterNameValue)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterValue(), other.parameterValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterName() != null) {
            sb.append("ParameterName: ").append(this.parameterName()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.of(clazz.cast(this.parameterName()));
            }
            case "ParameterValue": {
                return Optional.of(clazz.cast(this.parameterValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterNameValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterNameValue model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public ParameterNameValue build() {
            return new ParameterNameValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterNameValue> {
        public Builder parameterName(String var1);

        public Builder parameterValue(String var1);
    }
}

