/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.services.dax.transform.ParameterGroupStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterGroupStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterGroupStatus> {
    private final String parameterGroupName;
    private final String parameterApplyStatus;
    private final List<String> nodeIdsToReboot;

    private ParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.nodeIdsToReboot = builder.nodeIdsToReboot;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public List<String> nodeIdsToReboot() {
        return this.nodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeIdsToReboot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterGroupStatus)) {
            return false;
        }
        ParameterGroupStatus other = (ParameterGroupStatus)obj;
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterApplyStatus(), other.parameterApplyStatus()) && Objects.equals(this.nodeIdsToReboot(), other.nodeIdsToReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.parameterApplyStatus() != null) {
            sb.append("ParameterApplyStatus: ").append(this.parameterApplyStatus()).append(",");
        }
        if (this.nodeIdsToReboot() != null) {
            sb.append("NodeIdsToReboot: ").append(this.nodeIdsToReboot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.of(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterApplyStatus": {
                return Optional.of(clazz.cast(this.parameterApplyStatus()));
            }
            case "NodeIdsToReboot": {
                return Optional.of(clazz.cast(this.nodeIdsToReboot()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterGroupStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterApplyStatus;
        private List<String> nodeIdsToReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterGroupStatus model) {
            this.parameterGroupName(model.parameterGroupName);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.nodeIdsToReboot(model.nodeIdsToReboot);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getNodeIdsToReboot() {
            return this.nodeIdsToReboot;
        }

        @Override
        public final Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToReboot(String ... nodeIdsToReboot) {
            this.nodeIdsToReboot(Arrays.asList(nodeIdsToReboot));
            return this;
        }

        public final void setNodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
        }

        public ParameterGroupStatus build() {
            return new ParameterGroupStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterGroupStatus> {
        public Builder parameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder nodeIdsToReboot(Collection<String> var1);

        public Builder nodeIdsToReboot(String ... var1);
    }
}

