/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Endpoint;
import software.amazon.awssdk.services.dax.transform.NodeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Node
implements StructuredPojo,
ToCopyableBuilder<Builder, Node> {
    private final String nodeId;
    private final Endpoint endpoint;
    private final Instant nodeCreateTime;
    private final String availabilityZone;
    private final String nodeStatus;
    private final String parameterGroupStatus;

    private Node(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.endpoint = builder.endpoint;
        this.nodeCreateTime = builder.nodeCreateTime;
        this.availabilityZone = builder.availabilityZone;
        this.nodeStatus = builder.nodeStatus;
        this.parameterGroupStatus = builder.parameterGroupStatus;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Instant nodeCreateTime() {
        return this.nodeCreateTime;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String nodeStatus() {
        return this.nodeStatus;
    }

    public String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.nodeCreateTime(), other.nodeCreateTime()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.nodeStatus(), other.nodeStatus()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nodeId() != null) {
            sb.append("NodeId: ").append(this.nodeId()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.nodeCreateTime() != null) {
            sb.append("NodeCreateTime: ").append(this.nodeCreateTime()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.nodeStatus() != null) {
            sb.append("NodeStatus: ").append(this.nodeStatus()).append(",");
        }
        if (this.parameterGroupStatus() != null) {
            sb.append("ParameterGroupStatus: ").append(this.parameterGroupStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeId": {
                return Optional.of(clazz.cast(this.nodeId()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "NodeCreateTime": {
                return Optional.of(clazz.cast(this.nodeCreateTime()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "NodeStatus": {
                return Optional.of(clazz.cast(this.nodeStatus()));
            }
            case "ParameterGroupStatus": {
                return Optional.of(clazz.cast(this.parameterGroupStatus()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeId;
        private Endpoint endpoint;
        private Instant nodeCreateTime;
        private String availabilityZone;
        private String nodeStatus;
        private String parameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.nodeId(model.nodeId);
            this.endpoint(model.endpoint);
            this.nodeCreateTime(model.nodeCreateTime);
            this.availabilityZone(model.availabilityZone);
            this.nodeStatus(model.nodeStatus);
            this.parameterGroupStatus(model.parameterGroupStatus);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Instant getNodeCreateTime() {
            return this.nodeCreateTime;
        }

        @Override
        public final Builder nodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
            return this;
        }

        public final void setNodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getNodeStatus() {
            return this.nodeStatus;
        }

        @Override
        public final Builder nodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
            return this;
        }

        public final void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        public Node build() {
            return new Node(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Node> {
        public Builder nodeId(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(endpoint)).build());
        }

        public Builder nodeCreateTime(Instant var1);

        public Builder availabilityZone(String var1);

        public Builder nodeStatus(String var1);

        public Builder parameterGroupStatus(String var1);
    }
}

