/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;

@SdkInternalApi
public class CreateClusterRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterName").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Integer> REPLICATIONFACTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationFactor").build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZones").build();
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final MarshallingInfo<String> PREFERREDMAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredMaintenanceWindow").build();
    private static final MarshallingInfo<String> NOTIFICATIONTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationTopicArn").build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final MarshallingInfo<String> PARAMETERGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupName").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final CreateClusterRequestModelMarshaller INSTANCE = new CreateClusterRequestModelMarshaller();

    public static CreateClusterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateClusterRequest createClusterRequest, ProtocolMarshaller protocolMarshaller) {
        if (createClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createClusterRequest.clusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.replicationFactor(), REPLICATIONFACTOR_BINDING);
            protocolMarshaller.marshall(createClusterRequest.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.subnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall(createClusterRequest.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.preferredMaintenanceWindow(), PREFERREDMAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.notificationTopicArn(), NOTIFICATIONTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.iamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createClusterRequest.parameterGroupName(), PARAMETERGROUPNAME_BINDING);
            protocolMarshaller.marshall(createClusterRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

