/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Cluster;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterArn").build();
    private static final MarshallingInfo<Integer> TOTALNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalNodes").build();
    private static final MarshallingInfo<Integer> ACTIVENODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveNodes").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> CLUSTERDISCOVERYENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterDiscoveryEndpoint").build();
    private static final MarshallingInfo<List> NODEIDSTOREMOVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeIdsToRemove").build();
    private static final MarshallingInfo<List> NODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nodes").build();
    private static final MarshallingInfo<String> PREFERREDMAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredMaintenanceWindow").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfiguration").build();
    private static final MarshallingInfo<String> SUBNETGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroup").build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final MarshallingInfo<StructuredPojo> PARAMETERGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroup").build();
    private static final ClusterMarshaller INSTANCE = new ClusterMarshaller();

    public static ClusterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        if (cluster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cluster.clusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)cluster.clusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.totalNodes(), TOTALNODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.activeNodes(), ACTIVENODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)cluster.clusterDiscoveryEndpoint(), CLUSTERDISCOVERYENDPOINT_BINDING);
            protocolMarshaller.marshall(cluster.nodeIdsToRemove(), NODEIDSTOREMOVE_BINDING);
            protocolMarshaller.marshall(cluster.nodes(), NODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.preferredMaintenanceWindow(), PREFERREDMAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)cluster.notificationConfiguration(), NOTIFICATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)cluster.subnetGroup(), SUBNETGROUP_BINDING);
            protocolMarshaller.marshall(cluster.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)cluster.iamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.parameterGroup(), PARAMETERGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

