/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.dax.model.SubnetGroup;
import software.amazon.awssdk.services.dax.model.SubnetGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubnetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
    private final String nextToken;
    private final List<SubnetGroup> subnetGroups;

    private DescribeSubnetGroupsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.subnetGroups = builder.subnetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<SubnetGroup> subnetGroups() {
        return this.subnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.subnetGroups() == null ? 0 : this.subnetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsResponse)) {
            return false;
        }
        DescribeSubnetGroupsResponse other = (DescribeSubnetGroupsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.subnetGroups() == null ^ this.subnetGroups() == null) {
            return false;
        }
        return other.subnetGroups() == null || other.subnetGroups().equals(this.subnetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.subnetGroups() != null) {
            sb.append("SubnetGroups: ").append(this.subnetGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "SubnetGroups": {
                return Optional.of(clazz.cast(this.subnetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SubnetGroup> subnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsResponse model) {
            this.nextToken(model.nextToken);
            this.subnetGroups(model.subnetGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SubnetGroup.Builder> getSubnetGroups() {
            return this.subnetGroups != null ? (Collection)this.subnetGroups.stream().map(SubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetGroups(Collection<SubnetGroup> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copy(subnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(SubnetGroup ... subnetGroups) {
            this.subnetGroups(Arrays.asList(subnetGroups));
            return this;
        }

        public final void setSubnetGroups(Collection<SubnetGroup.BuilderImpl> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copyFromBuilder(subnetGroups);
        }

        public DescribeSubnetGroupsResponse build() {
            return new DescribeSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder subnetGroups(Collection<SubnetGroup> var1);

        public Builder subnetGroups(SubnetGroup ... var1);
    }
}

