/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.dax.model.ParameterGroup;
import software.amazon.awssdk.services.dax.model.ParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeParameterGroupsResponse> {
    private final String nextToken;
    private final List<ParameterGroup> parameterGroups;

    private DescribeParameterGroupsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.parameterGroups = builder.parameterGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ParameterGroup> parameterGroups() {
        return this.parameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.parameterGroups() == null ? 0 : this.parameterGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsResponse)) {
            return false;
        }
        DescribeParameterGroupsResponse other = (DescribeParameterGroupsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.parameterGroups() == null ^ this.parameterGroups() == null) {
            return false;
        }
        return other.parameterGroups() == null || other.parameterGroups().equals(this.parameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.parameterGroups() != null) {
            sb.append("ParameterGroups: ").append(this.parameterGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ParameterGroups": {
                return Optional.of(clazz.cast(this.parameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ParameterGroup> parameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsResponse model) {
            this.nextToken(model.nextToken);
            this.parameterGroups(model.parameterGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ParameterGroup.Builder> getParameterGroups() {
            return this.parameterGroups != null ? (Collection)this.parameterGroups.stream().map(ParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterGroups(Collection<ParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ParameterGroup ... parameterGroups) {
            this.parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        public final void setParameterGroups(Collection<ParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        public DescribeParameterGroupsResponse build() {
            return new DescribeParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeParameterGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder parameterGroups(Collection<ParameterGroup> var1);

        public Builder parameterGroups(ParameterGroup ... var1);
    }
}

