/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.ParameterGroupNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParameterGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeParameterGroupsRequest> {
    private final List<String> parameterGroupNames;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeParameterGroupsRequest(BuilderImpl builder) {
        this.parameterGroupNames = builder.parameterGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> parameterGroupNames() {
        return this.parameterGroupNames;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupNames() == null ? 0 : this.parameterGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsRequest)) {
            return false;
        }
        DescribeParameterGroupsRequest other = (DescribeParameterGroupsRequest)((Object)obj);
        if (other.parameterGroupNames() == null ^ this.parameterGroupNames() == null) {
            return false;
        }
        if (other.parameterGroupNames() != null && !other.parameterGroupNames().equals(this.parameterGroupNames())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterGroupNames() != null) {
            sb.append("ParameterGroupNames: ").append(this.parameterGroupNames()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupNames": {
                return Optional.of(clazz.cast(this.parameterGroupNames()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> parameterGroupNames;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsRequest model) {
            this.parameterGroupNames(model.parameterGroupNames);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getParameterGroupNames() {
            return this.parameterGroupNames;
        }

        @Override
        public final Builder parameterGroupNames(Collection<String> parameterGroupNames) {
            this.parameterGroupNames = ParameterGroupNameListCopier.copy(parameterGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroupNames(String ... parameterGroupNames) {
            this.parameterGroupNames(Arrays.asList(parameterGroupNames));
            return this;
        }

        public final void setParameterGroupNames(Collection<String> parameterGroupNames) {
            this.parameterGroupNames = ParameterGroupNameListCopier.copy(parameterGroupNames);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeParameterGroupsRequest build() {
            return new DescribeParameterGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeParameterGroupsRequest> {
        public Builder parameterGroupNames(Collection<String> var1);

        public Builder parameterGroupNames(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

