/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembership;

@SdkInternalApi
public class SecurityGroupMembershipMarshaller {
    private static final MarshallingInfo<String> SECURITYGROUPIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIdentifier").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final SecurityGroupMembershipMarshaller INSTANCE = new SecurityGroupMembershipMarshaller();

    public static SecurityGroupMembershipMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityGroupMembership securityGroupMembership, ProtocolMarshaller protocolMarshaller) {
        if (securityGroupMembership == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)securityGroupMembership.securityGroupIdentifier(), SECURITYGROUPIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)securityGroupMembership.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

