/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dax.model.SubnetGroup;
import software.amazon.awssdk.services.dax.model.SubnetGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubnetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
    private final String nextToken;
    private final List<SubnetGroup> subnetGroups;

    private DescribeSubnetGroupsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.subnetGroups = builder.subnetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<SubnetGroup> subnetGroups() {
        return this.subnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.subnetGroups() == null ? 0 : this.subnetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsResponse)) {
            return false;
        }
        DescribeSubnetGroupsResponse other = (DescribeSubnetGroupsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.subnetGroups() == null ^ this.subnetGroups() == null) {
            return false;
        }
        return other.subnetGroups() == null || other.subnetGroups().equals(this.subnetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.subnetGroups() != null) {
            sb.append("SubnetGroups: ").append(this.subnetGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SubnetGroup> subnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsResponse model) {
            this.setNextToken(model.nextToken);
            this.setSubnetGroups(model.subnetGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SubnetGroup> getSubnetGroups() {
            return this.subnetGroups;
        }

        @Override
        public final Builder subnetGroups(Collection<SubnetGroup> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copy(subnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroups(SubnetGroup ... subnetGroups) {
            this.subnetGroups(Arrays.asList(subnetGroups));
            return this;
        }

        public final void setSubnetGroups(Collection<SubnetGroup> subnetGroups) {
            this.subnetGroups = SubnetGroupListCopier.copy(subnetGroups);
        }

        public DescribeSubnetGroupsResponse build() {
            return new DescribeSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubnetGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder subnetGroups(Collection<SubnetGroup> var1);

        public Builder subnetGroups(SubnetGroup ... var1);
    }
}

