/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dax.model.Parameter;
import software.amazon.awssdk.services.dax.model.ParameterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeParametersResponse> {
    private final String nextToken;
    private final List<Parameter> parameters;

    private DescribeParametersResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.parameters = builder.parameters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersResponse)) {
            return false;
        }
        DescribeParametersResponse other = (DescribeParametersResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersResponse model) {
            this.setNextToken(model.nextToken);
            this.setParameters(model.parameters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
        }

        public DescribeParametersResponse build() {
            return new DescribeParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeParametersResponse> {
        public Builder nextToken(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

