/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UntagResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceName").isBinary(false).build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeys").isBinary(false).build();
    private static final UntagResourceRequestModelMarshaller INSTANCE = new UntagResourceRequestModelMarshaller();

    private UntagResourceRequestModelMarshaller() {
    }

    public static UntagResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UntagResourceRequest untagResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)untagResourceRequest), (String)"untagResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)untagResourceRequest.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall(untagResourceRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

