/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Endpoint;
import software.amazon.awssdk.services.dax.model.Node;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.services.dax.model.NodeListCopier;
import software.amazon.awssdk.services.dax.model.NotificationConfiguration;
import software.amazon.awssdk.services.dax.model.ParameterGroupStatus;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembership;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.dax.transform.ClusterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements StructuredPojo,
ToCopyableBuilder<Builder, Cluster> {
    private final String clusterName;
    private final String description;
    private final String clusterArn;
    private final Integer totalNodes;
    private final Integer activeNodes;
    private final String nodeType;
    private final String status;
    private final Endpoint clusterDiscoveryEndpoint;
    private final List<String> nodeIdsToRemove;
    private final List<Node> nodes;
    private final String preferredMaintenanceWindow;
    private final NotificationConfiguration notificationConfiguration;
    private final String subnetGroup;
    private final List<SecurityGroupMembership> securityGroups;
    private final String iamRoleArn;
    private final ParameterGroupStatus parameterGroup;

    private Cluster(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.clusterArn = builder.clusterArn;
        this.totalNodes = builder.totalNodes;
        this.activeNodes = builder.activeNodes;
        this.nodeType = builder.nodeType;
        this.status = builder.status;
        this.clusterDiscoveryEndpoint = builder.clusterDiscoveryEndpoint;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
        this.nodes = builder.nodes;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.subnetGroup = builder.subnetGroup;
        this.securityGroups = builder.securityGroups;
        this.iamRoleArn = builder.iamRoleArn;
        this.parameterGroup = builder.parameterGroup;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String description() {
        return this.description;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public Integer totalNodes() {
        return this.totalNodes;
    }

    public Integer activeNodes() {
        return this.activeNodes;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String status() {
        return this.status;
    }

    public Endpoint clusterDiscoveryEndpoint() {
        return this.clusterDiscoveryEndpoint;
    }

    public List<String> nodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public String subnetGroup() {
        return this.subnetGroup;
    }

    public List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public ParameterGroupStatus parameterGroup() {
        return this.parameterGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDiscoveryEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeIdsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.totalNodes(), other.totalNodes()) && Objects.equals(this.activeNodes(), other.activeNodes()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.clusterDiscoveryEndpoint(), other.clusterDiscoveryEndpoint()) && Objects.equals(this.nodeIdsToRemove(), other.nodeIdsToRemove()) && Objects.equals(this.nodes(), other.nodes()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && Objects.equals(this.subnetGroup(), other.subnetGroup()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.parameterGroup(), other.parameterGroup());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("ClusterName", (Object)this.clusterName()).add("Description", (Object)this.description()).add("ClusterArn", (Object)this.clusterArn()).add("TotalNodes", (Object)this.totalNodes()).add("ActiveNodes", (Object)this.activeNodes()).add("NodeType", (Object)this.nodeType()).add("Status", (Object)this.status()).add("ClusterDiscoveryEndpoint", (Object)this.clusterDiscoveryEndpoint()).add("NodeIdsToRemove", this.nodeIdsToRemove()).add("Nodes", this.nodes()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("SubnetGroup", (Object)this.subnetGroup()).add("SecurityGroups", this.securityGroups()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ParameterGroup", (Object)this.parameterGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.of(clazz.cast(this.clusterName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ClusterArn": {
                return Optional.of(clazz.cast(this.clusterArn()));
            }
            case "TotalNodes": {
                return Optional.of(clazz.cast(this.totalNodes()));
            }
            case "ActiveNodes": {
                return Optional.of(clazz.cast(this.activeNodes()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "ClusterDiscoveryEndpoint": {
                return Optional.of(clazz.cast(this.clusterDiscoveryEndpoint()));
            }
            case "NodeIdsToRemove": {
                return Optional.of(clazz.cast(this.nodeIdsToRemove()));
            }
            case "Nodes": {
                return Optional.of(clazz.cast(this.nodes()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationConfiguration": {
                return Optional.of(clazz.cast(this.notificationConfiguration()));
            }
            case "SubnetGroup": {
                return Optional.of(clazz.cast(this.subnetGroup()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "IamRoleArn": {
                return Optional.of(clazz.cast(this.iamRoleArn()));
            }
            case "ParameterGroup": {
                return Optional.of(clazz.cast(this.parameterGroup()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String description;
        private String clusterArn;
        private Integer totalNodes;
        private Integer activeNodes;
        private String nodeType;
        private String status;
        private Endpoint clusterDiscoveryEndpoint;
        private List<String> nodeIdsToRemove;
        private List<Node> nodes;
        private String preferredMaintenanceWindow;
        private NotificationConfiguration notificationConfiguration;
        private String subnetGroup;
        private List<SecurityGroupMembership> securityGroups;
        private String iamRoleArn;
        private ParameterGroupStatus parameterGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterName(model.clusterName);
            this.description(model.description);
            this.clusterArn(model.clusterArn);
            this.totalNodes(model.totalNodes);
            this.activeNodes(model.activeNodes);
            this.nodeType(model.nodeType);
            this.status(model.status);
            this.clusterDiscoveryEndpoint(model.clusterDiscoveryEndpoint);
            this.nodeIdsToRemove(model.nodeIdsToRemove);
            this.nodes(model.nodes);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationConfiguration(model.notificationConfiguration);
            this.subnetGroup(model.subnetGroup);
            this.securityGroups(model.securityGroups);
            this.iamRoleArn(model.iamRoleArn);
            this.parameterGroup(model.parameterGroup);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Integer getTotalNodes() {
            return this.totalNodes;
        }

        @Override
        public final Builder totalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
            return this;
        }

        public final void setTotalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
        }

        public final Integer getActiveNodes() {
            return this.activeNodes;
        }

        @Override
        public final Builder activeNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
            return this;
        }

        public final void setActiveNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Endpoint.Builder getClusterDiscoveryEndpoint() {
            return this.clusterDiscoveryEndpoint != null ? this.clusterDiscoveryEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder clusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint;
            return this;
        }

        public final void setClusterDiscoveryEndpoint(Endpoint.BuilderImpl clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint != null ? clusterDiscoveryEndpoint.build() : null;
        }

        public final Collection<String> getNodeIdsToRemove() {
            return this.nodeIdsToRemove;
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        public final Collection<Node.Builder> getNodes() {
            return this.nodes != null ? (Collection)this.nodes.stream().map(Node::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<Node.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (Node)((Node.Builder)Node.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodes(Collection<Node.BuilderImpl> nodes) {
            this.nodes = NodeListCopier.copyFromBuilder(nodes);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        public final String getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final Builder subnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public final void setSubnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
        }

        public final Collection<SecurityGroupMembership.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(SecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroupMembership)((SecurityGroupMembership.Builder)SecurityGroupMembership.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final ParameterGroupStatus.Builder getParameterGroup() {
            return this.parameterGroup != null ? this.parameterGroup.toBuilder() : null;
        }

        @Override
        public final Builder parameterGroup(ParameterGroupStatus parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public final void setParameterGroup(ParameterGroupStatus.BuilderImpl parameterGroup) {
            this.parameterGroup = parameterGroup != null ? parameterGroup.build() : null;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder clusterName(String var1);

        public Builder description(String var1);

        public Builder clusterArn(String var1);

        public Builder totalNodes(Integer var1);

        public Builder activeNodes(Integer var1);

        public Builder nodeType(String var1);

        public Builder status(String var1);

        public Builder clusterDiscoveryEndpoint(Endpoint var1);

        default public Builder clusterDiscoveryEndpoint(Consumer<Endpoint.Builder> clusterDiscoveryEndpoint) {
            return this.clusterDiscoveryEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().apply(clusterDiscoveryEndpoint)).build());
        }

        public Builder nodeIdsToRemove(Collection<String> var1);

        public Builder nodeIdsToRemove(String ... var1);

        public Builder nodes(Collection<Node> var1);

        public Builder nodes(Node ... var1);

        public Builder nodes(Consumer<Node.Builder> ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().apply(notificationConfiguration)).build());
        }

        public Builder subnetGroup(String var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... var1);

        public Builder iamRoleArn(String var1);

        public Builder parameterGroup(ParameterGroupStatus var1);

        default public Builder parameterGroup(Consumer<ParameterGroupStatus.Builder> parameterGroup) {
            return this.parameterGroup((ParameterGroupStatus)((ParameterGroupStatus.Builder)ParameterGroupStatus.builder().apply(parameterGroup)).build());
        }
    }
}

