/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.Subnet;

@SdkInternalApi
public class SubnetMarshaller {
    private static final MarshallingInfo<String> SUBNETIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIdentifier").build();
    private static final MarshallingInfo<String> SUBNETAVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetAvailabilityZone").build();
    private static final SubnetMarshaller instance = new SubnetMarshaller();

    public static SubnetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Subnet subnet, ProtocolMarshaller protocolMarshaller) {
        if (subnet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subnet.subnetIdentifier(), SUBNETIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)subnet.subnetAvailabilityZone(), SUBNETAVAILABILITYZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

